/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import dagger.Component;
import dagger.Subcomponent;
import dagger.internal.codegen.AbstractComponentProcessingStep;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingGraphValidator;
import dagger.internal.codegen.BuilderValidator;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentGenerator;
import dagger.internal.codegen.ComponentValidator;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

final class ComponentProcessingStep
extends AbstractComponentProcessingStep {
    private final Messager messager;
    private final ComponentValidator componentValidator;
    private final ComponentValidator subcomponentValidator;
    private final BuilderValidator componentBuilderValidator;
    private final BuilderValidator subcomponentBuilderValidator;
    private final ComponentDescriptor.Factory componentDescriptorFactory;

    ComponentProcessingStep(Messager messager, ComponentValidator componentValidator, ComponentValidator subcomponentValidator, BuilderValidator componentBuilderValidator, BuilderValidator subcomponentBuilderValidator, BindingGraphValidator bindingGraphValidator, ComponentDescriptor.Factory componentDescriptorFactory, BindingGraph.Factory bindingGraphFactory, ComponentGenerator componentGenerator) {
        super(messager, bindingGraphValidator, bindingGraphFactory, componentGenerator);
        this.messager = messager;
        this.componentValidator = componentValidator;
        this.subcomponentValidator = subcomponentValidator;
        this.componentBuilderValidator = componentBuilderValidator;
        this.subcomponentBuilderValidator = subcomponentBuilderValidator;
        this.componentDescriptorFactory = componentDescriptorFactory;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(Component.class, Subcomponent.class);
    }

    protected ImmutableSet<ComponentDescriptor> componentDescriptors(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        ImmutableMap builderReportsByComponent = ImmutableMap.of();
        ImmutableSet subcomponentBuilderElements = ImmutableSet.of();
        Map<Element, ValidationReport<TypeElement>> builderReportsBySubcomponent = this.processSubcomponentBuilders((Set<? extends Element>)subcomponentBuilderElements);
        Set subcomponentElements = elementsByAnnotation.get(Subcomponent.class);
        Map<Element, ValidationReport<TypeElement>> reportsBySubcomponent = this.processSubcomponents(subcomponentElements, (Set<? extends Element>)subcomponentBuilderElements);
        Set componentElements = elementsByAnnotation.get(Component.class);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Element element : componentElements) {
            TypeElement componentTypeElement = MoreElements.asType(element);
            ComponentValidator.ComponentValidationReport report = this.componentValidator.validate(componentTypeElement, subcomponentElements, (Set<? extends Element>)subcomponentBuilderElements);
            report.report().printMessagesTo(this.messager);
            if (!this.isClean(report, (Map<Element, ValidationReport<TypeElement>>)builderReportsByComponent, reportsBySubcomponent, builderReportsBySubcomponent)) continue;
            try {
                builder.add((Object)this.componentDescriptorFactory.forComponent(componentTypeElement));
            }
            catch (TypeNotPresentException e) {}
        }
        return builder.build();
    }

    private Map<Element, ValidationReport<TypeElement>> processComponentBuilders(Set<? extends Element> componentBuilderElements) {
        HashMap builderReportsByComponent = Maps.newHashMap();
        for (Element element : componentBuilderElements) {
            ValidationReport<TypeElement> report = this.componentBuilderValidator.validate(MoreElements.asType(element));
            report.printMessagesTo(this.messager);
            builderReportsByComponent.put(element.getEnclosingElement(), report);
        }
        return builderReportsByComponent;
    }

    private Map<Element, ValidationReport<TypeElement>> processSubcomponentBuilders(Set<? extends Element> subcomponentBuilderElements) {
        HashMap builderReportsBySubcomponent = Maps.newHashMap();
        for (Element element : subcomponentBuilderElements) {
            ValidationReport<TypeElement> report = this.subcomponentBuilderValidator.validate(MoreElements.asType(element));
            report.printMessagesTo(this.messager);
            builderReportsBySubcomponent.put(element, report);
        }
        return builderReportsBySubcomponent;
    }

    private Map<Element, ValidationReport<TypeElement>> processSubcomponents(Set<? extends Element> subcomponentElements, Set<? extends Element> subcomponentBuilderElements) {
        HashMap reportsBySubcomponent = Maps.newHashMap();
        for (Element element : subcomponentElements) {
            ComponentValidator.ComponentValidationReport report = this.subcomponentValidator.validate(MoreElements.asType(element), subcomponentElements, subcomponentBuilderElements);
            report.report().printMessagesTo(this.messager);
            reportsBySubcomponent.put(element, report.report());
        }
        return reportsBySubcomponent;
    }

    private boolean isClean(ComponentValidator.ComponentValidationReport report, Map<Element, ValidationReport<TypeElement>> builderReportsByComponent, Map<Element, ValidationReport<TypeElement>> reportsBySubcomponent, Map<Element, ValidationReport<TypeElement>> builderReportsBySubcomponent) {
        Element component = report.report().subject();
        ValidationReport<TypeElement> componentReport = report.report();
        if (!componentReport.isClean()) {
            return false;
        }
        ValidationReport<TypeElement> builderReport = builderReportsByComponent.get(component);
        if (builderReport != null && !builderReport.isClean()) {
            return false;
        }
        for (Element element : report.referencedSubcomponents()) {
            ValidationReport<TypeElement> subcomponentBuilderReport = builderReportsBySubcomponent.get(element);
            if (subcomponentBuilderReport != null && !subcomponentBuilderReport.isClean()) {
                return false;
            }
            ValidationReport<TypeElement> subcomponentReport = reportsBySubcomponent.get(element);
            if (subcomponentReport == null || subcomponentReport.isClean()) continue;
            return false;
        }
        return true;
    }
}

