/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Sets;
import dagger.Module;
import dagger.Subcomponent;
import dagger.internal.codegen.AutoValue_ComponentValidator_ComponentValidationReport;
import dagger.internal.codegen.BuilderValidator;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.ModuleValidator;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

final class ComponentValidator {
    private final Elements elements;
    private final Types types;
    private final ComponentDescriptor.Kind componentType;
    private final ModuleValidator moduleValidator;
    private final ComponentValidator subcomponentValidator;
    private final BuilderValidator subcomponentBuilderValidator;

    private ComponentValidator(Elements elements, Types types, ModuleValidator moduleValidator, BuilderValidator subcomponentBuilderValidator) {
        this.elements = elements;
        this.types = types;
        this.componentType = ComponentDescriptor.Kind.SUBCOMPONENT;
        this.moduleValidator = moduleValidator;
        this.subcomponentValidator = this;
        this.subcomponentBuilderValidator = subcomponentBuilderValidator;
    }

    private ComponentValidator(Elements elements, Types types, ModuleValidator moduleValidator, ComponentValidator subcomponentValidator, BuilderValidator subcomponentBuilderValidator) {
        this.elements = elements;
        this.types = types;
        this.componentType = ComponentDescriptor.Kind.COMPONENT;
        this.moduleValidator = moduleValidator;
        this.subcomponentValidator = subcomponentValidator;
        this.subcomponentBuilderValidator = subcomponentBuilderValidator;
    }

    static ComponentValidator createForComponent(Elements elements, Types types, ModuleValidator moduleValidator, ComponentValidator subcomponentValidator, BuilderValidator subcomponentBuilderValidator) {
        return new ComponentValidator(elements, types, moduleValidator, subcomponentValidator, subcomponentBuilderValidator);
    }

    static ComponentValidator createForSubcomponent(Elements elements, Types types, ModuleValidator moduleValidator, BuilderValidator subcomponentBuilderValidator) {
        return new ComponentValidator(elements, types, moduleValidator, subcomponentBuilderValidator);
    }

    public ComponentValidationReport validate(TypeElement subject, Set<? extends Element> validatedSubcomponents, Set<? extends Element> validatedSubcomponentBuilders) {
        ImmutableList builders;
        ValidationReport.Builder<TypeElement> builder = ValidationReport.Builder.about(subject);
        if (!(subject.getKind().equals((Object)ElementKind.INTERFACE) || subject.getKind().equals((Object)ElementKind.CLASS) && subject.getModifiers().contains((Object)Modifier.ABSTRACT))) {
            builder.addItem(String.format("@%s may only be applied to an interface or abstract class", this.componentType.annotationType().getSimpleName()), subject);
        }
        if ((builders = ImmutableList.of()).size() > 1) {
            builder.addItem(String.format(ErrorMessages.builderMsgsFor(this.componentType).moreThanOne(), builders), subject);
        }
        DeclaredType subjectType = MoreTypes.asDeclared(subject.asType());
        List<? extends Element> members = this.elements.getAllMembers(subject);
        LinkedHashMultimap referencedSubcomponents = LinkedHashMultimap.create();
        block4: for (ExecutableElement executableElement : ElementFilter.methodsIn(members)) {
            if (!executableElement.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(subjectType, executableElement));
            List<? extends TypeMirror> parameterTypes = resolvedMethod.getParameterTypes();
            List<? extends VariableElement> parameters = executableElement.getParameters();
            TypeMirror returnType = resolvedMethod.getReturnType();
            Optional<AnnotationMirror> subcomponentAnnotation = this.checkForAnnotation(returnType, Subcomponent.class);
            Optional subcomponentBuilderAnnotation = Optional.absent();
            if (subcomponentAnnotation.isPresent()) {
                referencedSubcomponents.put((Object)MoreTypes.asElement(returnType), (Object)executableElement);
                this.validateSubcomponentMethod(builder, executableElement, parameters, parameterTypes, returnType, subcomponentAnnotation);
                continue;
            }
            if (subcomponentBuilderAnnotation.isPresent()) {
                referencedSubcomponents.put((Object)MoreTypes.asElement(returnType).getEnclosingElement(), (Object)executableElement);
                this.validateSubcomponentBuilderMethod(builder, executableElement, parameters, returnType, validatedSubcomponentBuilders);
                continue;
            }
            switch (parameters.size()) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    TypeMirror onlyParameter = (TypeMirror)Iterables.getOnlyElement(parameterTypes);
                    if (returnType.getKind().equals((Object)TypeKind.VOID) || this.types.isSameType(returnType, onlyParameter)) continue block4;
                    builder.addItem("Members injection methods may only return the injected type or void.", executableElement);
                    continue block4;
                }
            }
            builder.addItem("This method isn't a valid provision method, members injection method or subcomponent factory method. Dagger cannot implement this method", executableElement);
        }
        for (Map.Entry entry : referencedSubcomponents.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            builder.addItem(String.format(ErrorMessages.SubcomponentBuilderMessages.INSTANCE.moreThanOneRefToSubcomponent(), entry.getKey(), entry.getValue()), subject);
        }
        AnnotationMirror componentMirror = (AnnotationMirror)MoreElements.getAnnotationMirror(subject, this.componentType.annotationType()).get();
        ImmutableList<TypeMirror> immutableList = ConfigurationAnnotations.getComponentModules(componentMirror);
        this.moduleValidator.validateReferencedModules(subject, builder, immutableList);
        ImmutableSet.Builder allSubcomponents = ImmutableSet.builder().addAll((Iterable)referencedSubcomponents.keySet());
        for (Element subcomponent : Sets.difference((Set)referencedSubcomponents.keySet(), validatedSubcomponents)) {
            ComponentValidationReport subreport = this.subcomponentValidator.validate(MoreElements.asType(subcomponent), validatedSubcomponents, validatedSubcomponentBuilders);
            builder.addItems((Iterable<ValidationReport.Item>)subreport.report().items());
            allSubcomponents.addAll(subreport.referencedSubcomponents());
        }
        return new AutoValue_ComponentValidator_ComponentValidationReport((Set<Element>)allSubcomponents.build(), builder.build());
    }

    private void validateSubcomponentMethod(ValidationReport.Builder<TypeElement> builder, ExecutableElement method, List<? extends VariableElement> parameters, List<? extends TypeMirror> parameterTypes, TypeMirror returnType, Optional<AnnotationMirror> subcomponentAnnotation) {
        ImmutableSet<TypeElement> moduleTypes = MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentModules((AnnotationMirror)subcomponentAnnotation.get()));
        ImmutableSet<TypeElement> transitiveModules = ConfigurationAnnotations.getTransitiveModules(this.types, this.elements, moduleTypes);
        ImmutableSet requiredModules = FluentIterable.from(transitiveModules).filter((Predicate)new Predicate<TypeElement>(){

            public boolean apply(TypeElement input) {
                return !Util.componentCanMakeNewInstances(input);
            }
        }).toSet();
        HashSet variableTypes = Sets.newHashSet();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            TypeMirror parameterType = parameterTypes.get(i);
            Optional<TypeElement> moduleType = parameterType.accept(new SimpleTypeVisitor6<Optional<TypeElement>, Void>(){

                @Override
                protected Optional<TypeElement> defaultAction(TypeMirror e, Void p) {
                    return Optional.absent();
                }

                @Override
                public Optional<TypeElement> visitDeclared(DeclaredType t, Void p) {
                    return MoreElements.isAnnotationPresent(t.asElement(), Module.class) ? Optional.of((Object)MoreTypes.asTypeElement(t)) : Optional.absent();
                }
            }, null);
            if (moduleType.isPresent()) {
                if (variableTypes.contains(moduleType.get())) {
                    builder.addItem(String.format("A module may only occur once an an argument in a Subcomponent factory method, but %s was already passed.", ((TypeElement)moduleType.get()).getQualifiedName()), parameter);
                }
                if (!transitiveModules.contains(moduleType.get())) {
                    builder.addItem(String.format("%s is present as an argument to the %s factory method, but is not one of the modules used to implement the subcomponent.", ((TypeElement)moduleType.get()).getQualifiedName(), MoreTypes.asTypeElement(returnType).getQualifiedName()), method);
                }
                variableTypes.add(moduleType.get());
                continue;
            }
            builder.addItem(String.format("Subcomponent factory methods may only accept modules, but %s is not.", parameterType), parameter);
        }
        Sets.SetView missingModules = Sets.difference((Set)requiredModules, (Set)ImmutableSet.copyOf((Collection)variableTypes));
        if (!missingModules.isEmpty()) {
            builder.addItem(String.format("%s requires modules which have no visible default constructors. Add the following modules as parameters to this method: %s", MoreTypes.asTypeElement(returnType).getQualifiedName(), Joiner.on((String)", ").join((Iterable)missingModules)), method);
        }
    }

    private void validateSubcomponentBuilderMethod(ValidationReport.Builder<TypeElement> builder, ExecutableElement method, List<? extends VariableElement> parameters, TypeMirror returnType, Set<? extends Element> validatedSubcomponentBuilders) {
        TypeElement builderElement;
        if (!parameters.isEmpty()) {
            builder.addItem(ErrorMessages.SubcomponentBuilderMessages.INSTANCE.builderMethodRequiresNoArgs(), method);
        }
        if (!validatedSubcomponentBuilders.contains(builderElement = MoreTypes.asTypeElement(returnType))) {
            builder.addItems((Iterable<ValidationReport.Item>)this.subcomponentBuilderValidator.validate(builderElement).items());
        }
    }

    private Optional<AnnotationMirror> checkForAnnotation(TypeMirror type, final Class<? extends Annotation> annotation) {
        return type.accept(new SimpleTypeVisitor6<Optional<AnnotationMirror>, Void>(){

            @Override
            protected Optional<AnnotationMirror> defaultAction(TypeMirror e, Void p) {
                return Optional.absent();
            }

            @Override
            public Optional<AnnotationMirror> visitDeclared(DeclaredType t, Void p) {
                return MoreElements.getAnnotationMirror(t.asElement(), annotation);
            }
        }, null);
    }

    static abstract class ComponentValidationReport {
        ComponentValidationReport() {
        }

        abstract Set<Element> referencedSubcomponents();

        abstract ValidationReport<TypeElement> report();
    }
}

