/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import dagger.internal.codegen.Binding;
import java.util.Comparator;
import java.util.EnumSet;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

abstract class ContributionBinding
extends Binding {
    ContributionBinding() {
    }

    abstract BindingType bindingType();

    abstract Optional<DeclaredType> nullableType();

    abstract Optional<TypeElement> contributedBy();

    abstract boolean isSyntheticBinding();

    abstract Class<?> frameworkClass();

    static <B extends ContributionBinding> ImmutableListMultimap<BindingType, B> bindingTypesFor(Iterable<? extends B> bindings) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        builder.orderKeysBy((Comparator)Ordering.natural());
        for (ContributionBinding binding : bindings) {
            builder.put((Object)binding.bindingType(), (Object)binding);
        }
        return builder.build();
    }

    static BindingType bindingTypeFor(Iterable<? extends ContributionBinding> bindings) {
        Preconditions.checkNotNull(bindings);
        Preconditions.checkArgument((!Iterables.isEmpty(bindings) ? 1 : 0) != 0, (Object)"no bindings");
        EnumSet<BindingType> types = EnumSet.noneOf(BindingType.class);
        for (ContributionBinding contributionBinding : bindings) {
            types.add(contributionBinding.bindingType());
        }
        if (types.size() > 1) {
            throw new IllegalArgumentException(String.format("More than one binding present of different types %s", types));
        }
        return (BindingType)((Object)Iterables.getOnlyElement(types));
    }

    static enum BindingType {
        MAP,
        SET,
        UNIQUE;


        boolean isMultibinding() {
            return !this.equals((Object)UNIQUE);
        }
    }
}

