/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.Lazy;
import dagger.MembersInjector;
import dagger.internal.codegen.AutoValue_DependencyRequest;
import dagger.internal.codegen.AutoValue_DependencyRequest_Factory_KindAndType;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.Key;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

abstract class DependencyRequest {
    DependencyRequest() {
    }

    abstract Kind kind();

    abstract Key key();

    BindingKey bindingKey() {
        switch (this.kind()) {
            case INSTANCE: 
            case LAZY: 
            case PROVIDER: 
            case PRODUCER: 
            case PRODUCED: 
            case FUTURE: {
                return BindingKey.create(BindingKey.Kind.CONTRIBUTION, this.key());
            }
            case MEMBERS_INJECTOR: {
                return BindingKey.create(BindingKey.Kind.MEMBERS_INJECTION, this.key());
            }
        }
        throw new AssertionError();
    }

    abstract Element requestElement();

    abstract DeclaredType enclosingType();

    abstract boolean isNullable();

    static final class Factory {
        private final Key.Factory keyFactory;

        Factory(Key.Factory keyFactory) {
            this.keyFactory = keyFactory;
        }

        ImmutableSet<DependencyRequest> forRequiredResolvedVariables(DeclaredType container, List<? extends VariableElement> variables, List<? extends TypeMirror> resolvedTypes) {
            Preconditions.checkState((resolvedTypes.size() == variables.size() ? 1 : 0) != 0);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (int i = 0; i < variables.size(); ++i) {
                builder.add((Object)this.forRequiredResolvedVariable(container, variables.get(i), resolvedTypes.get(i)));
            }
            return builder.build();
        }

        ImmutableSet<DependencyRequest> forRequiredVariables(List<? extends VariableElement> variables) {
            return FluentIterable.from(variables).transform((Function)new Function<VariableElement, DependencyRequest>(){

                public DependencyRequest apply(VariableElement input) {
                    return Factory.this.forRequiredVariable(input);
                }
            }).toSet();
        }

        DependencyRequest forImplicitMapBinding(DependencyRequest delegatingRequest, Key delegateKey) {
            Preconditions.checkNotNull((Object)delegatingRequest);
            return new AutoValue_DependencyRequest(Kind.PROVIDER, delegateKey, delegatingRequest.requestElement(), Factory.getEnclosingType(delegatingRequest.requestElement()), false);
        }

        DependencyRequest forRequiredVariable(VariableElement variableElement) {
            Preconditions.checkNotNull((Object)variableElement);
            TypeMirror type = variableElement.asType();
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(variableElement);
            return this.newDependencyRequest(variableElement, type, qualifier, Factory.getEnclosingType(variableElement));
        }

        DependencyRequest forRequiredResolvedVariable(DeclaredType container, VariableElement variableElement, TypeMirror resolvedType) {
            Preconditions.checkNotNull((Object)variableElement);
            Preconditions.checkNotNull((Object)resolvedType);
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(variableElement);
            return this.newDependencyRequest(variableElement, resolvedType, qualifier, container);
        }

        DependencyRequest forComponentProvisionMethod(ExecutableElement provisionMethod, ExecutableType provisionMethodType) {
            Preconditions.checkNotNull((Object)provisionMethod);
            Preconditions.checkNotNull((Object)provisionMethodType);
            Preconditions.checkArgument((boolean)provisionMethod.getParameters().isEmpty(), (Object)("Component provision methods must be empty: " + provisionMethod));
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(provisionMethod);
            return this.newDependencyRequest(provisionMethod, provisionMethodType.getReturnType(), qualifier, Factory.getEnclosingType(provisionMethod));
        }

        DependencyRequest forComponentProductionMethod(ExecutableElement productionMethod, ExecutableType productionMethodType) {
            Preconditions.checkNotNull((Object)productionMethod);
            Preconditions.checkNotNull((Object)productionMethodType);
            Preconditions.checkArgument((boolean)productionMethod.getParameters().isEmpty(), (String)"Component production methods must be empty: %s", (Object[])new Object[]{productionMethod});
            TypeMirror type = productionMethodType.getReturnType();
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(productionMethod);
            DeclaredType container = Factory.getEnclosingType(productionMethod);
            if (MoreTypes.isTypeOf(ListenableFuture.class, type)) {
                return new AutoValue_DependencyRequest(Kind.FUTURE, this.keyFactory.forQualifiedType(qualifier, (TypeMirror)Iterables.getOnlyElement(((DeclaredType)type).getTypeArguments())), productionMethod, container, false);
            }
            return this.newDependencyRequest(productionMethod, type, qualifier, container);
        }

        DependencyRequest forComponentMembersInjectionMethod(ExecutableElement membersInjectionMethod, ExecutableType membersInjectionMethodType) {
            Preconditions.checkNotNull((Object)membersInjectionMethod);
            Preconditions.checkNotNull((Object)membersInjectionMethodType);
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(membersInjectionMethod);
            Preconditions.checkArgument((!qualifier.isPresent() ? 1 : 0) != 0);
            TypeMirror returnType = membersInjectionMethodType.getReturnType();
            if (returnType.getKind().equals((Object)TypeKind.DECLARED) && MoreTypes.isTypeOf(MembersInjector.class, returnType)) {
                return new AutoValue_DependencyRequest(Kind.MEMBERS_INJECTOR, this.keyFactory.forMembersInjectedType((TypeMirror)Iterables.getOnlyElement(((DeclaredType)returnType).getTypeArguments())), membersInjectionMethod, Factory.getEnclosingType(membersInjectionMethod), false);
            }
            return new AutoValue_DependencyRequest(Kind.MEMBERS_INJECTOR, this.keyFactory.forMembersInjectedType((TypeMirror)Iterables.getOnlyElement(membersInjectionMethodType.getParameterTypes())), membersInjectionMethod, Factory.getEnclosingType(membersInjectionMethod), false);
        }

        DependencyRequest forMembersInjectedType(DeclaredType type) {
            return new AutoValue_DependencyRequest(Kind.MEMBERS_INJECTOR, this.keyFactory.forMembersInjectedType(type), type.asElement(), type, false);
        }

        private DependencyRequest newDependencyRequest(Element requestElement, TypeMirror type, Optional<AnnotationMirror> qualifier, DeclaredType container) {
            KindAndType kindAndType = Factory.extractKindAndType(type);
            if (kindAndType.kind().equals((Object)Kind.MEMBERS_INJECTOR)) {
                Preconditions.checkArgument((!qualifier.isPresent() ? 1 : 0) != 0);
            }
            boolean allowsNull = !kindAndType.kind().equals((Object)Kind.INSTANCE) || ConfigurationAnnotations.getNullableType(requestElement).isPresent();
            return new AutoValue_DependencyRequest(kindAndType.kind(), this.keyFactory.forQualifiedType(qualifier, kindAndType.type()), requestElement, container, allowsNull);
        }

        static KindAndType extractKindAndType(TypeMirror type) {
            if (type.getKind().equals((Object)TypeKind.ERROR)) {
                throw new TypeNotPresentException(type.toString(), null);
            }
            if (type.getKind().equals((Object)TypeKind.TYPEVAR)) {
                return new AutoValue_DependencyRequest_Factory_KindAndType(Kind.INSTANCE, type);
            }
            if (MoreTypes.isTypeOf(Provider.class, type)) {
                return new AutoValue_DependencyRequest_Factory_KindAndType(Kind.PROVIDER, (TypeMirror)Iterables.getOnlyElement(((DeclaredType)type).getTypeArguments()));
            }
            if (MoreTypes.isTypeOf(Lazy.class, type)) {
                return new AutoValue_DependencyRequest_Factory_KindAndType(Kind.LAZY, (TypeMirror)Iterables.getOnlyElement(((DeclaredType)type).getTypeArguments()));
            }
            if (MoreTypes.isTypeOf(MembersInjector.class, type)) {
                return new AutoValue_DependencyRequest_Factory_KindAndType(Kind.MEMBERS_INJECTOR, (TypeMirror)Iterables.getOnlyElement(((DeclaredType)type).getTypeArguments()));
            }
            if (MoreTypes.isTypeOf(Producer.class, type)) {
                return new AutoValue_DependencyRequest_Factory_KindAndType(Kind.PRODUCER, (TypeMirror)Iterables.getOnlyElement(((DeclaredType)type).getTypeArguments()));
            }
            if (MoreTypes.isTypeOf(Produced.class, type)) {
                return new AutoValue_DependencyRequest_Factory_KindAndType(Kind.PRODUCED, (TypeMirror)Iterables.getOnlyElement(((DeclaredType)type).getTypeArguments()));
            }
            return new AutoValue_DependencyRequest_Factory_KindAndType(Kind.INSTANCE, type);
        }

        static DeclaredType getEnclosingType(Element element) {
            while (!MoreElements.isType(element)) {
                element = element.getEnclosingElement();
            }
            return MoreTypes.asDeclared(element.asType());
        }

        static abstract class KindAndType {
            KindAndType() {
            }

            abstract Kind kind();

            abstract TypeMirror type();
        }
    }

    static enum Kind {
        INSTANCE,
        PROVIDER,
        LAZY,
        MEMBERS_INJECTOR,
        PRODUCER,
        PRODUCED,
        FUTURE;

    }
}

