/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import dagger.MembersInjector;
import dagger.Provides;
import dagger.internal.Factory;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.ComponentProcessor;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.DependencyRequestMapper;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.ClassWriter;
import dagger.internal.codegen.writer.ConstructorWriter;
import dagger.internal.codegen.writer.EnumWriter;
import dagger.internal.codegen.writer.FieldWriter;
import dagger.internal.codegen.writer.JavaWriter;
import dagger.internal.codegen.writer.MethodWriter;
import dagger.internal.codegen.writer.ParameterizedTypeName;
import dagger.internal.codegen.writer.Snippet;
import dagger.internal.codegen.writer.StringLiteral;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.TypeNames;
import dagger.internal.codegen.writer.TypeVariableName;
import dagger.internal.codegen.writer.TypeWriter;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

final class FactoryGenerator
extends SourceFileGenerator<ProvisionBinding> {
    private final DependencyRequestMapper dependencyRequestMapper;
    private final Diagnostic.Kind nullableValidationType;

    FactoryGenerator(Filer filer, DependencyRequestMapper dependencyRequestMapper, Diagnostic.Kind nullableValidationType) {
        super(filer);
        this.dependencyRequestMapper = dependencyRequestMapper;
        this.nullableValidationType = nullableValidationType;
    }

    @Override
    ClassName nameGeneratedType(ProvisionBinding binding) {
        return SourceFiles.factoryNameForProvisionBinding(binding);
    }

    @Override
    Iterable<? extends Element> getOriginatingElements(ProvisionBinding binding) {
        return ImmutableSet.of((Object)binding.bindingElement());
    }

    @Override
    Optional<? extends Element> getElementForErrorReporting(ProvisionBinding binding) {
        return Optional.of((Object)binding.bindingElement());
    }

    @Override
    ImmutableSet<JavaWriter> write(ClassName generatedTypeName, ProvisionBinding binding) {
        TypeWriter factoryWriter;
        Optional constructorWriter;
        Preconditions.checkState((!binding.hasNonDefaultTypeParameters() ? 1 : 0) != 0);
        TypeMirror keyType = binding.provisionType().equals((Object)Provides.Type.MAP) ? Util.getProvidedValueTypeOfMap(MoreTypes.asDeclared(binding.key().type())) : binding.key().type();
        TypeName providedTypeName = TypeNames.forTypeMirror(keyType);
        JavaWriter writer = JavaWriter.inPackage(generatedTypeName.packageName());
        ArrayList typeParameters = Lists.newArrayList();
        for (TypeParameterElement typeParameterElement : binding.bindingTypeElement().getTypeParameters()) {
            typeParameters.add(TypeVariableName.fromTypeParameterElement(typeParameterElement));
        }
        switch (binding.factoryCreationStrategy()) {
            case ENUM_INSTANCE: {
                EnumWriter enumWriter = writer.addEnum(generatedTypeName.simpleName());
                enumWriter.addConstant("INSTANCE");
                constructorWriter = Optional.absent();
                factoryWriter = enumWriter;
                if (typeParameters.isEmpty()) break;
                factoryWriter.annotate(SuppressWarnings.class).setValue("rawtypes");
                providedTypeName = ((ParameterizedTypeName)providedTypeName).type();
                break;
            }
            case CLASS_CONSTRUCTOR: {
                ClassWriter classWriter = writer.addClass(generatedTypeName.simpleName());
                classWriter.addTypeParameters(typeParameters);
                classWriter.addModifiers(Modifier.FINAL, new Modifier[0]);
                constructorWriter = Optional.of((Object)classWriter.addConstructor());
                ((ConstructorWriter)constructorWriter.get()).addModifiers(Modifier.PUBLIC, new Modifier[0]);
                factoryWriter = classWriter;
                if (!binding.bindingKind().equals((Object)ProvisionBinding.Kind.PROVISION) || binding.bindingElement().getModifiers().contains((Object)Modifier.STATIC)) break;
                TypeName enclosingType = TypeNames.forTypeMirror(binding.bindingTypeElement().asType());
                factoryWriter.addField(enclosingType, "module").addModifiers(Modifier.PRIVATE, Modifier.FINAL);
                ((ConstructorWriter)constructorWriter.get()).addParameter(enclosingType, "module");
                ((ConstructorWriter)constructorWriter.get()).body().addSnippet("assert module != null;", new Object[0]).addSnippet("this.module = module;", new Object[0]);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        factoryWriter.annotate(Generated.class).setValue(ComponentProcessor.class.getName());
        factoryWriter.addModifiers(Modifier.PUBLIC, new Modifier[0]);
        factoryWriter.addImplementedType(ParameterizedTypeName.create(ClassName.fromClass(Factory.class), providedTypeName));
        MethodWriter getMethodWriter = factoryWriter.addMethod(providedTypeName, "get");
        getMethodWriter.annotate(Override.class);
        getMethodWriter.addModifiers(Modifier.PUBLIC, new Modifier[0]);
        if (binding.memberInjectionRequest().isPresent()) {
            ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.create(MembersInjector.class, providedTypeName);
            factoryWriter.addField(parameterizedTypeName, "membersInjector").addModifiers(Modifier.PRIVATE, Modifier.FINAL);
            ((ConstructorWriter)constructorWriter.get()).addParameter(parameterizedTypeName, "membersInjector");
            ((ConstructorWriter)constructorWriter.get()).body().addSnippet("assert membersInjector != null;", new Object[0]).addSnippet("this.membersInjector = membersInjector;", new Object[0]);
        }
        ImmutableMap<BindingKey, FrameworkField> immutableMap = SourceFiles.generateBindingFieldsForDependencies(this.dependencyRequestMapper, binding.dependencies());
        for (FrameworkField bindingField : immutableMap.values()) {
            TypeName fieldType = bindingField.frameworkType();
            FieldWriter field = factoryWriter.addField(fieldType, bindingField.name());
            field.addModifiers(Modifier.PRIVATE, Modifier.FINAL);
            ((ConstructorWriter)constructorWriter.get()).addParameter(field.type(), field.name());
            ((ConstructorWriter)constructorWriter.get()).body().addSnippet("assert %s != null;", field.name()).addSnippet("this.%1$s = %1$s;", field.name());
        }
        block4 : switch (binding.bindingKind()) {
            case INJECTION: 
            case PROVISION: {
                ParameterizedTypeName returnType = ParameterizedTypeName.create(ClassName.fromClass(Factory.class), TypeNames.forTypeMirror(keyType));
                MethodWriter createMethodWriter = factoryWriter.addMethod(returnType, "create");
                createMethodWriter.addTypeParameters(typeParameters);
                createMethodWriter.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
                ImmutableMap params = constructorWriter.isPresent() ? ((ConstructorWriter)constructorWriter.get()).parameters() : ImmutableMap.of();
                for (Map.Entry param : params.entrySet()) {
                    createMethodWriter.addParameter((TypeName)param.getValue(), (String)param.getKey());
                }
                switch (binding.factoryCreationStrategy()) {
                    case ENUM_INSTANCE: {
                        if (typeParameters.isEmpty()) {
                            createMethodWriter.body().addSnippet("return INSTANCE;", new Object[0]);
                            break block4;
                        }
                        createMethodWriter.annotate(SuppressWarnings.class).setValue("unchecked");
                        createMethodWriter.body().addSnippet("return (Factory) INSTANCE;", new Object[0]);
                        break block4;
                    }
                    case CLASS_CONSTRUCTOR: {
                        createMethodWriter.body().addSnippet("return new %s(%s);", SourceFiles.parameterizedFactoryNameForProvisionBinding(binding), Joiner.on((String)", ").join(params.keySet()));
                        break block4;
                    }
                }
                throw new AssertionError();
            }
        }
        ArrayList parameters = Lists.newArrayList();
        for (DependencyRequest dependency : binding.dependencies()) {
            parameters.add(SourceFiles.frameworkTypeUsageStatement(Snippet.format(((FrameworkField)immutableMap.get((Object)dependency.bindingKey())).name(), new Object[0]), dependency.kind()));
        }
        Snippet parametersSnippet = Snippet.makeParametersSnippet(parameters);
        if (binding.bindingKind().equals((Object)ProvisionBinding.Kind.PROVISION)) {
            Snippet providesMethodInvocation = Snippet.format("%s.%s(%s)", binding.bindingElement().getModifiers().contains((Object)Modifier.STATIC) ? ClassName.fromTypeElement(binding.bindingTypeElement()) : "module", binding.bindingElement().getSimpleName(), parametersSnippet);
            if (binding.provisionType().equals((Object)Provides.Type.SET)) {
                TypeName paramTypeName = TypeNames.forTypeMirror(MoreTypes.asDeclared(keyType).getTypeArguments().get(0));
                getMethodWriter.body().addSnippet("return %s.<%s>singleton(%s);", ClassName.fromClass(Collections.class), paramTypeName, providesMethodInvocation);
            } else if (binding.nullableType().isPresent() || this.nullableValidationType.equals((Object)Diagnostic.Kind.WARNING)) {
                if (binding.nullableType().isPresent()) {
                    getMethodWriter.annotate((ClassName)TypeNames.forTypeMirror((TypeMirror)binding.nullableType().get()));
                }
                getMethodWriter.body().addSnippet("return %s;", providesMethodInvocation);
            } else {
                StringLiteral failMsg = StringLiteral.forValue("Cannot return null from a non-@Nullable @Provides method");
                getMethodWriter.body().addSnippet(Snippet.format(Joiner.on((char)'\n').join((Object)"%s provided = %s;", (Object)"if (provided == null) {", new Object[]{"  throw new NullPointerException(%s);", "}", "return provided;"}), getMethodWriter.returnType(), providesMethodInvocation, failMsg));
            }
        } else if (binding.memberInjectionRequest().isPresent()) {
            getMethodWriter.body().addSnippet("%1$s instance = new %1$s(%2$s);", providedTypeName, parametersSnippet);
            getMethodWriter.body().addSnippet("membersInjector.injectMembers(instance);", new Object[0]);
            getMethodWriter.body().addSnippet("return instance;", new Object[0]);
        } else {
            getMethodWriter.body().addSnippet("return new %s(%s);", providedTypeName, parametersSnippet);
        }
        return ImmutableSet.of((Object)writer);
    }
}

