/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.FactoryGenerator;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MembersInjectorGenerator;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.SourceFileGenerationException;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.writer.ClassName;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class InjectBindingRegistry {
    private final Elements elements;
    private final Types types;
    private final Messager messager;
    private final ProvisionBinding.Factory provisionBindingFactory;
    private final MembersInjectionBinding.Factory membersInjectionBindingFactory;
    private final BindingsCollection<ProvisionBinding> provisionBindings = new BindingsCollection();
    private final BindingsCollection<MembersInjectionBinding> membersInjectionBindings = new BindingsCollection();

    InjectBindingRegistry(Elements elements, Types types, Messager messager, ProvisionBinding.Factory provisionBindingFactory, MembersInjectionBinding.Factory membersInjectionBindingFactory) {
        this.elements = elements;
        this.types = types;
        this.messager = messager;
        this.provisionBindingFactory = provisionBindingFactory;
        this.membersInjectionBindingFactory = membersInjectionBindingFactory;
    }

    void generateSourcesForRequiredBindings(FactoryGenerator factoryGenerator, MembersInjectorGenerator membersInjectorGenerator) throws SourceFileGenerationException {
        this.provisionBindings.generateBindings(factoryGenerator);
        this.membersInjectionBindings.generateBindings(membersInjectorGenerator);
    }

    ProvisionBinding registerBinding(ProvisionBinding binding) {
        return this.registerBinding(binding, true);
    }

    MembersInjectionBinding registerBinding(MembersInjectionBinding binding) {
        return this.registerBinding(binding, true);
    }

    private ProvisionBinding registerBinding(ProvisionBinding binding, boolean explicit) {
        ClassName factoryName = SourceFiles.factoryNameForProvisionBinding(binding);
        this.provisionBindings.tryRegisterBinding(binding, factoryName, explicit);
        if (binding.hasNonDefaultTypeParameters()) {
            this.provisionBindings.tryToGenerateBinding(this.provisionBindingFactory.unresolve(binding), factoryName, explicit);
        }
        return binding;
    }

    private MembersInjectionBinding registerBinding(MembersInjectionBinding binding, boolean explicit) {
        ClassName membersInjectorName = SourceFiles.membersInjectorNameForMembersInjectionBinding(binding);
        if (binding.injectionSites().isEmpty()) {
            this.membersInjectionBindings.pretendBindingGenerated(binding, membersInjectorName);
            if (binding.hasNonDefaultTypeParameters()) {
                this.membersInjectionBindings.pretendBindingGenerated(this.membersInjectionBindingFactory.unresolve(binding), membersInjectorName);
            }
        } else {
            this.membersInjectionBindings.tryRegisterBinding(binding, membersInjectorName, explicit);
            if (binding.hasNonDefaultTypeParameters()) {
                this.membersInjectionBindings.tryToGenerateBinding(this.membersInjectionBindingFactory.unresolve(binding), membersInjectorName, explicit);
            }
        }
        return binding;
    }

    Optional<ProvisionBinding> getOrFindProvisionBinding(Key key) {
        Preconditions.checkNotNull((Object)key);
        if (!key.isValidImplicitProvisionKey(this.types)) {
            return Optional.absent();
        }
        ProvisionBinding binding = this.provisionBindings.getBinding(key);
        if (binding != null) {
            return Optional.of((Object)binding);
        }
        TypeElement element = MoreElements.asType(this.types.asElement(key.type()));
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(element.getEnclosedElements());
        ImmutableSet injectConstructors = FluentIterable.from(constructors).filter((Predicate)new Predicate<ExecutableElement>(){

            public boolean apply(ExecutableElement input) {
                return MoreElements.isAnnotationPresent(input, Inject.class);
            }
        }).toSet();
        switch (injectConstructors.size()) {
            case 0: {
                return Optional.absent();
            }
            case 1: {
                ProvisionBinding constructorBinding = this.provisionBindingFactory.forInjectConstructor((ExecutableElement)Iterables.getOnlyElement((Iterable)injectConstructors), (Optional<TypeMirror>)Optional.of((Object)key.type()));
                return Optional.of((Object)this.registerBinding(constructorBinding, false));
            }
        }
        throw new IllegalStateException("Found multiple @Inject constructors: " + injectConstructors);
    }

    MembersInjectionBinding getOrFindMembersInjectionBinding(Key key) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((boolean)key.isValidMembersInjectionKey());
        MembersInjectionBinding binding = this.membersInjectionBindings.getBinding(key);
        if (binding != null) {
            return binding;
        }
        return this.registerBinding(this.membersInjectionBindingFactory.forInjectedType(MoreTypes.asDeclared(key.type()), (Optional<TypeMirror>)Optional.of((Object)key.type())), false);
    }

    final class BindingsCollection<B extends Binding> {
        private final Map<Key, B> bindingsByKey = Maps.newLinkedHashMap();
        private final Deque<B> bindingsRequiringGeneration = new ArrayDeque<B>();
        private final Set<B> materializedBindings = Sets.newLinkedHashSet();

        BindingsCollection() {
        }

        void generateBindings(SourceFileGenerator<B> generator) throws SourceFileGenerationException {
            Binding binding = (Binding)this.bindingsRequiringGeneration.poll();
            while (binding != null) {
                Preconditions.checkState((!binding.hasNonDefaultTypeParameters() ? 1 : 0) != 0);
                generator.generate(binding);
                this.materializedBindings.add(binding);
                binding = (Binding)this.bindingsRequiringGeneration.poll();
            }
        }

        B getBinding(Key key) {
            return (B)((Binding)this.bindingsByKey.get(key));
        }

        B pretendBindingGenerated(B binding, ClassName factoryName) {
            this.tryToCacheBinding(binding);
            if (this.shouldGenerateBinding(binding, factoryName)) {
                this.materializedBindings.add(binding);
            }
            return binding;
        }

        void tryRegisterBinding(B binding, ClassName factoryName, boolean explicit) {
            this.tryToCacheBinding(binding);
            this.tryToGenerateBinding(binding, factoryName, explicit);
        }

        void tryToGenerateBinding(B binding, ClassName factoryName, boolean explicit) {
            if (this.shouldGenerateBinding(binding, factoryName)) {
                this.bindingsRequiringGeneration.offer(binding);
                if (!explicit) {
                    InjectBindingRegistry.this.messager.printMessage(Diagnostic.Kind.NOTE, String.format("Generating a MembersInjector or Factory for %s. Prefer to run the dagger processor over that class instead.", InjectBindingRegistry.this.types.erasure(((Binding)binding).key().type())));
                }
            }
        }

        private boolean shouldGenerateBinding(B binding, ClassName factoryName) {
            return !((Binding)binding).hasNonDefaultTypeParameters() && InjectBindingRegistry.this.elements.getTypeElement(factoryName.canonicalName()) == null && !this.materializedBindings.contains(binding) && !this.bindingsRequiringGeneration.contains(binding);
        }

        private void tryToCacheBinding(B binding) {
            if (((Binding)binding).hasNonDefaultTypeParameters() || ((Binding)binding).bindingTypeElement().getTypeParameters().isEmpty()) {
                Key key = ((Binding)binding).key();
                Binding previousValue = (Binding)this.bindingsByKey.put(key, binding);
                Preconditions.checkState((previousValue == null || binding.equals(previousValue) ? 1 : 0) != 0, (String)"couldn't register %s. %s was already registered for %s", (Object[])new Object[]{binding, previousValue, key});
            }
        }
    }
}

