/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.ValidationReport;
import dagger.internal.codegen.Validator;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

final class InjectFieldValidator
implements Validator<VariableElement> {
    InjectFieldValidator() {
    }

    @Override
    public ValidationReport<VariableElement> validate(VariableElement fieldElement) {
        ImmutableSet<? extends AnnotationMirror> qualifiers;
        ValidationReport.Builder<VariableElement> builder = ValidationReport.Builder.about(fieldElement);
        Set<Modifier> modifiers = fieldElement.getModifiers();
        if (modifiers.contains((Object)Modifier.FINAL)) {
            builder.addItem("@Inject fields may not be final", fieldElement);
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            builder.addItem("Dagger does not support injection into private fields", fieldElement);
        }
        if ((qualifiers = InjectionAnnotations.getQualifiers(fieldElement)).size() > 1) {
            for (AnnotationMirror qualifier : qualifiers) {
                builder.addItem("A single injection site may not use more than one @Qualifier.", fieldElement, qualifier);
            }
        }
        return builder.build();
    }
}

