/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.ValidationReport;
import dagger.internal.codegen.Validator;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

final class InjectMethodValidator
implements Validator<ExecutableElement> {
    InjectMethodValidator() {
    }

    @Override
    public ValidationReport<ExecutableElement> validate(ExecutableElement methodElement) {
        ValidationReport.Builder<ExecutableElement> builder = ValidationReport.Builder.about(methodElement);
        Set<Modifier> modifiers = methodElement.getModifiers();
        if (modifiers.contains((Object)Modifier.ABSTRACT)) {
            builder.addItem("Methods with @Inject may not be abstract.", methodElement);
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            builder.addItem("Dagger does not support injection into private methods", methodElement);
        }
        if (!methodElement.getTypeParameters().isEmpty()) {
            builder.addItem("Methods with @Inject may not declare type parameters.", methodElement);
        }
        for (VariableElement variableElement : methodElement.getParameters()) {
            ImmutableSet<? extends AnnotationMirror> qualifiers = InjectionAnnotations.getQualifiers(variableElement);
            if (qualifiers.size() <= 1) continue;
            for (AnnotationMirror qualifier : qualifiers) {
                builder.addItem("A single injection site may not use more than one @Qualifier.", methodElement, qualifier);
            }
        }
        return builder.build();
    }
}

