/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.InjectBindingRegistry;
import dagger.internal.codegen.InjectConstructorValidator;
import dagger.internal.codegen.InjectFieldValidator;
import dagger.internal.codegen.InjectMethodValidator;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor6;

final class InjectProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;
    private final InjectConstructorValidator constructorValidator;
    private final InjectFieldValidator fieldValidator;
    private final InjectMethodValidator methodValidator;
    private final ProvisionBinding.Factory provisionBindingFactory;
    private final MembersInjectionBinding.Factory membersInjectionBindingFactory;
    private final InjectBindingRegistry injectBindingRegistry;

    InjectProcessingStep(Messager messager, InjectConstructorValidator constructorValidator, InjectFieldValidator fieldValidator, InjectMethodValidator methodValidator, ProvisionBinding.Factory provisionBindingFactory, MembersInjectionBinding.Factory membersInjectionBindingFactory, InjectBindingRegistry factoryRegistrar) {
        this.messager = messager;
        this.constructorValidator = constructorValidator;
        this.fieldValidator = fieldValidator;
        this.methodValidator = methodValidator;
        this.provisionBindingFactory = provisionBindingFactory;
        this.membersInjectionBindingFactory = membersInjectionBindingFactory;
        this.injectBindingRegistry = factoryRegistrar;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(Inject.class);
    }

    @Override
    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        final ImmutableSet.Builder provisions = ImmutableSet.builder();
        final ImmutableSet.Builder membersInjectedTypes = ImmutableSet.builder();
        for (Element injectElement : elementsByAnnotation.get(Inject.class)) {
            injectElement.accept(new ElementKindVisitor6<Void, Void>(){

                @Override
                public Void visitExecutableAsConstructor(ExecutableElement constructorElement, Void v) {
                    ValidationReport<ExecutableElement> report = InjectProcessingStep.this.constructorValidator.validate(constructorElement);
                    report.printMessagesTo(InjectProcessingStep.this.messager);
                    if (report.isClean()) {
                        provisions.add((Object)InjectProcessingStep.this.provisionBindingFactory.forInjectConstructor(constructorElement, (Optional<TypeMirror>)Optional.absent()));
                    }
                    return null;
                }

                @Override
                public Void visitVariableAsField(VariableElement fieldElement, Void p) {
                    ValidationReport<VariableElement> report = InjectProcessingStep.this.fieldValidator.validate(fieldElement);
                    report.printMessagesTo(InjectProcessingStep.this.messager);
                    if (report.isClean()) {
                        membersInjectedTypes.add((Object)MoreTypes.asDeclared(fieldElement.getEnclosingElement().asType()));
                    }
                    return null;
                }

                @Override
                public Void visitExecutableAsMethod(ExecutableElement methodElement, Void p) {
                    ValidationReport<ExecutableElement> report = InjectProcessingStep.this.methodValidator.validate(methodElement);
                    report.printMessagesTo(InjectProcessingStep.this.messager);
                    if (report.isClean()) {
                        membersInjectedTypes.add((Object)MoreTypes.asDeclared(methodElement.getEnclosingElement().asType()));
                    }
                    return null;
                }
            }, null);
        }
        for (DeclaredType injectedType : membersInjectedTypes.build()) {
            this.injectBindingRegistry.registerBinding(this.membersInjectionBindingFactory.forInjectedType(injectedType, (Optional<TypeMirror>)Optional.absent()));
        }
        for (ProvisionBinding binding : provisions.build()) {
            this.injectBindingRegistry.registerBinding(binding);
        }
        return ImmutableSet.of();
    }
}

