/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dagger.shaded.auto.common.AnnotationMirrors;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

final class InjectionAnnotations {
    static Optional<AnnotationMirror> getScopeAnnotation(Element e) {
        Preconditions.checkNotNull((Object)e);
        ImmutableSet<? extends AnnotationMirror> scopeAnnotations = InjectionAnnotations.getScopes(e);
        switch (scopeAnnotations.size()) {
            case 0: {
                return Optional.absent();
            }
            case 1: {
                return Optional.of((Object)scopeAnnotations.iterator().next());
            }
        }
        throw new IllegalArgumentException(e + " was annotated with more than one @Scope annotation");
    }

    static Optional<AnnotationMirror> getQualifier(Element e) {
        Preconditions.checkNotNull((Object)e);
        ImmutableSet<? extends AnnotationMirror> qualifierAnnotations = InjectionAnnotations.getQualifiers(e);
        switch (qualifierAnnotations.size()) {
            case 0: {
                return Optional.absent();
            }
            case 1: {
                return Optional.of((Object)qualifierAnnotations.iterator().next());
            }
        }
        throw new IllegalArgumentException(e + " was annotated with more than one @Qualifier annotation");
    }

    static ImmutableSet<? extends AnnotationMirror> getQualifiers(Element element) {
        return AnnotationMirrors.getAnnotatedAnnotations(element, Qualifier.class);
    }

    static ImmutableSet<? extends AnnotationMirror> getScopes(Element element) {
        return AnnotationMirrors.getAnnotatedAnnotations(element, Scope.class);
    }

    private InjectionAnnotations() {
    }
}

