/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.MapKey;
import dagger.Provides;
import dagger.internal.codegen.AutoValue_Key;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.Util;
import dagger.producers.Producer;
import dagger.producers.Produces;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

abstract class Key {
    Key() {
    }

    abstract Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedQualifier();

    abstract Equivalence.Wrapper<TypeMirror> wrappedType();

    Optional<AnnotationMirror> qualifier() {
        return Util.unwrapOptionalEquivalence(this.wrappedQualifier());
    }

    TypeMirror type() {
        return (TypeMirror)this.wrappedType().get();
    }

    private static TypeMirror normalize(Types types, TypeMirror type) {
        TypeKind kind = type.getKind();
        return kind.isPrimitive() ? types.boxedClass((PrimitiveType)type).asType() : type;
    }

    Key withType(Types types, TypeMirror newType) {
        return new AutoValue_Key(this.wrappedQualifier(), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)Key.normalize(types, newType)));
    }

    boolean isValidMembersInjectionKey() {
        return !this.qualifier().isPresent();
    }

    boolean isValidImplicitProvisionKey(final Types types) {
        if (this.qualifier().isPresent()) {
            return false;
        }
        return this.type().accept(new SimpleTypeVisitor6<Boolean, Void>(){

            @Override
            protected Boolean defaultAction(TypeMirror e, Void p) {
                return false;
            }

            @Override
            public Boolean visitDeclared(DeclaredType type, Void ignored) {
                TypeElement element = MoreElements.asType(type.asElement());
                if (!element.getKind().equals((Object)ElementKind.CLASS) || element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    return false;
                }
                for (TypeMirror typeMirror : type.getTypeArguments()) {
                    if (typeMirror.getKind() == TypeKind.DECLARED) continue;
                    return false;
                }
                return MoreTypes.asDeclared(element.asType()).getTypeArguments().isEmpty() || !types.isSameType(types.erasure(element.asType()), Key.this.type());
            }
        }, null);
    }

    public String toString() {
        return MoreObjects.toStringHelper(Key.class).omitNullValues().add("qualifier", this.qualifier().orNull()).add("type", (Object)this.type()).toString();
    }

    static final class Factory {
        private final Types types;
        private final Elements elements;

        Factory(Types types, Elements elements) {
            this.types = (Types)Preconditions.checkNotNull((Object)types);
            this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
        }

        private TypeElement getSetElement() {
            return this.elements.getTypeElement(Set.class.getCanonicalName());
        }

        private TypeElement getMapElement() {
            return this.elements.getTypeElement(Map.class.getCanonicalName());
        }

        private TypeElement getProviderElement() {
            return this.elements.getTypeElement(Provider.class.getCanonicalName());
        }

        private TypeElement getProducerElement() {
            return this.elements.getTypeElement(Producer.class.getCanonicalName());
        }

        private TypeElement getClassElement(Class<?> cls) {
            return this.elements.getTypeElement(cls.getCanonicalName());
        }

        Key forComponentMethod(ExecutableElement componentMethod) {
            Preconditions.checkNotNull((Object)componentMethod);
            Preconditions.checkArgument((boolean)componentMethod.getKind().equals((Object)ElementKind.METHOD));
            TypeMirror returnType = Key.normalize(this.types, componentMethod.getReturnType());
            return this.forMethod(componentMethod, returnType);
        }

        Key forProductionComponentMethod(ExecutableElement componentMethod) {
            TypeMirror returnType;
            Preconditions.checkNotNull((Object)componentMethod);
            Preconditions.checkArgument((boolean)componentMethod.getKind().equals((Object)ElementKind.METHOD));
            TypeMirror keyType = returnType = Key.normalize(this.types, componentMethod.getReturnType());
            if (MoreTypes.isTypeOf(ListenableFuture.class, returnType)) {
                keyType = (TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared(returnType).getTypeArguments());
            }
            return this.forMethod(componentMethod, keyType);
        }

        Key forProvidesMethod(ExecutableType executableType, ExecutableElement method) {
            Preconditions.checkNotNull((Object)method);
            Preconditions.checkArgument((boolean)method.getKind().equals((Object)ElementKind.METHOD));
            Provides providesAnnotation = method.getAnnotation(Provides.class);
            Preconditions.checkArgument((providesAnnotation != null ? 1 : 0) != 0);
            TypeMirror returnType = Key.normalize(this.types, executableType.getReturnType());
            TypeMirror keyType = this.providesOrProducesKeyType(returnType, method, (Optional<Provides.Type>)Optional.of((Object)providesAnnotation.type()), (Optional<Produces.Type>)Optional.absent());
            return this.forMethod(method, keyType);
        }

        Key forProducesMethod(ExecutableType executableType, ExecutableElement method) {
            TypeMirror returnType;
            Preconditions.checkNotNull((Object)method);
            Preconditions.checkArgument((boolean)method.getKind().equals((Object)ElementKind.METHOD));
            Produces producesAnnotation = method.getAnnotation(Produces.class);
            Preconditions.checkArgument((producesAnnotation != null ? 1 : 0) != 0);
            TypeMirror unfuturedType = returnType = Key.normalize(this.types, executableType.getReturnType());
            if (MoreTypes.isTypeOf(ListenableFuture.class, returnType)) {
                unfuturedType = (TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared(returnType).getTypeArguments());
            }
            TypeMirror keyType = this.providesOrProducesKeyType(unfuturedType, method, (Optional<Provides.Type>)Optional.absent(), (Optional<Produces.Type>)Optional.of((Object)producesAnnotation.type()));
            return this.forMethod(method, keyType);
        }

        private TypeMirror providesOrProducesKeyType(TypeMirror returnType, ExecutableElement method, Optional<Provides.Type> providesType, Optional<Produces.Type> producesType) {
            switch (providesType.isPresent() ? (Provides.Type)providesType.get() : Provides.Type.valueOf((String)((Produces.Type)producesType.get()).name())) {
                case UNIQUE: {
                    return returnType;
                }
                case SET: {
                    return this.types.getDeclaredType(this.getSetElement(), returnType);
                }
                case MAP: {
                    return this.mapOfFactoryType(method, returnType, providesType.isPresent() ? this.getProviderElement() : this.getProducerElement());
                }
                case SET_VALUES: {
                    Preconditions.checkArgument((MoreTypes.isType(returnType) && MoreTypes.isTypeOf(Set.class, returnType) ? 1 : 0) != 0);
                    return returnType;
                }
            }
            throw new AssertionError();
        }

        private TypeMirror mapOfFactoryType(ExecutableElement method, TypeMirror valueType, TypeElement factoryType) {
            TypeMirror mapKeyType = this.mapKeyType(method);
            DeclaredType mapValueFactoryType = this.types.getDeclaredType(factoryType, valueType);
            return this.types.getDeclaredType(this.getMapElement(), mapKeyType, mapValueFactoryType);
        }

        private TypeMirror mapKeyType(ExecutableElement method) {
            AnnotationMirror mapKeyAnnotation = (AnnotationMirror)MapKeys.getMapKey(method).get();
            MapKey mapKey = mapKeyAnnotation.getAnnotationType().asElement().getAnnotation(MapKey.class);
            return mapKey.unwrapValue() ? MapKeys.getUnwrappedMapKeyType(mapKeyAnnotation.getAnnotationType(), this.types) : mapKeyAnnotation.getAnnotationType();
        }

        private Key forMethod(ExecutableElement method, TypeMirror keyType) {
            return new AutoValue_Key(Util.wrapOptionalInEquivalence(AnnotationMirrors.equivalence(), InjectionAnnotations.getQualifier(method)), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)keyType));
        }

        Key forInjectConstructorWithResolvedType(TypeMirror type) {
            return new AutoValue_Key((Optional<Equivalence.Wrapper<AnnotationMirror>>)Optional.absent(), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)type));
        }

        Key forComponent(TypeMirror type) {
            return new AutoValue_Key((Optional<Equivalence.Wrapper<AnnotationMirror>>)Optional.absent(), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)Key.normalize(this.types, type)));
        }

        Key forMembersInjectedType(TypeMirror type) {
            return new AutoValue_Key((Optional<Equivalence.Wrapper<AnnotationMirror>>)Optional.absent(), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)Key.normalize(this.types, type)));
        }

        Key forQualifiedType(Optional<AnnotationMirror> qualifier, TypeMirror type) {
            return new AutoValue_Key(Util.wrapOptionalInEquivalence(AnnotationMirrors.equivalence(), qualifier), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)Key.normalize(this.types, type)));
        }

        Optional<Key> implicitMapProviderKeyFrom(Key possibleMapKey) {
            return this.maybeWrapMapValue(possibleMapKey, Provider.class);
        }

        Optional<Key> implicitMapProducerKeyFrom(Key possibleMapKey) {
            return this.maybeWrapMapValue(possibleMapKey, Producer.class);
        }

        private Optional<Key> maybeWrapMapValue(Key possibleMapKey, Class<?> wrappingClass) {
            DeclaredType declaredMapType;
            TypeMirror mapValueType;
            if (MoreTypes.isTypeOf(Map.class, possibleMapKey.type()) && !MoreTypes.isTypeOf(wrappingClass, mapValueType = Util.getValueTypeOfMap(declaredMapType = MoreTypes.asDeclared(possibleMapKey.type())))) {
                DeclaredType keyType = Util.getKeyTypeOfMap(declaredMapType);
                TypeElement wrappingElement = this.getClassElement(wrappingClass);
                if (wrappingElement == null) {
                    return Optional.absent();
                }
                DeclaredType wrappedType = this.types.getDeclaredType(wrappingElement, mapValueType);
                DeclaredType mapType = this.types.getDeclaredType(this.getMapElement(), keyType, wrappedType);
                return Optional.of((Object)new AutoValue_Key(possibleMapKey.wrappedQualifier(), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)mapType)));
            }
            return Optional.absent();
        }
    }
}

