/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoAnnotation;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.AutoValue_MapKeyGenerator_MapKeyCreatorSpecification;
import dagger.internal.codegen.ComponentProcessor;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.ClassWriter;
import dagger.internal.codegen.writer.JavaWriter;
import dagger.internal.codegen.writer.MethodWriter;
import dagger.internal.codegen.writer.Snippet;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.TypeNames;
import dagger.internal.codegen.writer.TypeWriter;
import dagger.shaded.auto.common.MoreTypes;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor6;

final class MapKeyGenerator
extends SourceFileGenerator<MapKeyCreatorSpecification> {
    private static final SimpleTypeVisitor6<Void, Set<TypeElement>> TRAVERSE_NESTED_ANNOTATIONS = new SimpleTypeVisitor6<Void, Set<TypeElement>>(){

        @Override
        public Void visitDeclared(DeclaredType t, Set<TypeElement> p) {
            TypeElement typeElement = MoreTypes.asTypeElement(t);
            if (typeElement.getKind() == ElementKind.ANNOTATION_TYPE) {
                MapKeyGenerator.nestedAnnotationElements(typeElement, p);
            }
            return null;
        }
    };

    MapKeyGenerator(Filer filer) {
        super(filer);
    }

    @Override
    ClassName nameGeneratedType(MapKeyCreatorSpecification mapKeyCreatorType) {
        return MapKeys.getMapKeyCreatorClassName(mapKeyCreatorType.mapKeyElement());
    }

    @Override
    Iterable<? extends Element> getOriginatingElements(MapKeyCreatorSpecification mapKeyCreatorType) {
        return ImmutableSet.of((Object)mapKeyCreatorType.mapKeyElement());
    }

    @Override
    Optional<? extends Element> getElementForErrorReporting(MapKeyCreatorSpecification mapKeyCreatorType) {
        return Optional.of((Object)mapKeyCreatorType.mapKeyElement());
    }

    @Override
    ImmutableSet<JavaWriter> write(ClassName generatedTypeName, MapKeyCreatorSpecification mapKeyCreatorType) {
        JavaWriter writer = JavaWriter.inPackage(generatedTypeName.packageName());
        ClassWriter mapKeyCreatorWriter = writer.addClass(generatedTypeName.simpleName());
        mapKeyCreatorWriter.annotate(Generated.class).setValue(ComponentProcessor.class.getName());
        mapKeyCreatorWriter.addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        for (TypeElement annotationElement : MapKeyGenerator.nestedAnnotationElements(mapKeyCreatorType.annotationElement())) {
            this.writeCreateMethod(mapKeyCreatorWriter, annotationElement);
        }
        return ImmutableSet.of((Object)writer);
    }

    private void writeCreateMethod(TypeWriter mapKeyCreatorWriter, TypeElement annotationElement) {
        MethodWriter createMethod = mapKeyCreatorWriter.addMethod(annotationElement.asType(), "create" + annotationElement.getSimpleName());
        createMethod.annotate(AutoAnnotation.class);
        createMethod.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (ExecutableElement annotationMember : ElementFilter.methodsIn(annotationElement.getEnclosedElements())) {
            String parameterName = annotationMember.getSimpleName().toString();
            TypeName parameterType = TypeNames.forTypeMirror(annotationMember.getReturnType());
            createMethod.addParameter(parameterType, parameterName);
            parameters.add((Object)Snippet.format("%s", parameterName));
        }
        ClassName autoAnnotationClass = mapKeyCreatorWriter.name().peerNamed("AutoAnnotation_" + mapKeyCreatorWriter.name().simpleName() + "_" + createMethod.name());
        createMethod.body().addSnippet("return new %s(%s);", autoAnnotationClass, Snippet.makeParametersSnippet((Iterable<Snippet>)parameters.build()));
    }

    private static Set<TypeElement> nestedAnnotationElements(TypeElement annotationElement) {
        return MapKeyGenerator.nestedAnnotationElements(annotationElement, new LinkedHashSet<TypeElement>());
    }

    private static Set<TypeElement> nestedAnnotationElements(TypeElement annotationElement, Set<TypeElement> annotationElements) {
        if (annotationElements.add(annotationElement)) {
            for (ExecutableElement method : ElementFilter.methodsIn(annotationElement.getEnclosedElements())) {
                TRAVERSE_NESTED_ANNOTATIONS.visit(method.getReturnType(), annotationElements);
            }
        }
        return annotationElements;
    }

    static abstract class MapKeyCreatorSpecification {
        MapKeyCreatorSpecification() {
        }

        abstract TypeElement mapKeyElement();

        abstract TypeElement annotationElement();

        static MapKeyCreatorSpecification wrappedMapKey(TypeElement mapKeyElement) {
            return new AutoValue_MapKeyGenerator_MapKeyCreatorSpecification(mapKeyElement, mapKeyElement);
        }

        static MapKeyCreatorSpecification unwrappedMapKeyWithAnnotationValue(TypeElement mapKeyElement, TypeElement annotationElement) {
            return new AutoValue_MapKeyGenerator_MapKeyCreatorSpecification(mapKeyElement, annotationElement);
        }
    }
}

