/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.MapKey;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.Snippet;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.TypeNames;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

final class MapKeys {
    private static final SimpleTypeVisitor6<Snippet, Snippet> ARRAY_LITERAL_PREFIX = new SimpleTypeVisitor6<Snippet, Snippet>(){

        @Override
        public Snippet visitArray(ArrayType t, Snippet p) {
            return Snippet.format("new %s[] %s", RAW_TYPE_NAME.visit(t.getComponentType()), p);
        }

        @Override
        protected Snippet defaultAction(TypeMirror e, Snippet p) {
            return p;
        }
    };
    private static final SimpleTypeVisitor6<TypeName, Void> RAW_TYPE_NAME = new SimpleTypeVisitor6<TypeName, Void>(){

        @Override
        public TypeName visitDeclared(DeclaredType t, Void p) {
            return ClassName.fromTypeElement(MoreTypes.asTypeElement(t));
        }

        @Override
        protected TypeName defaultAction(TypeMirror e, Void p) {
            return TypeNames.forTypeMirror(e);
        }
    };

    static Optional<? extends AnnotationMirror> getMapKey(Element bindingElement) {
        ImmutableSet<? extends AnnotationMirror> mapKeys = MapKeys.getMapKeys(bindingElement);
        return mapKeys.isEmpty() ? Optional.absent() : Optional.of((Object)Iterables.getOnlyElement(mapKeys));
    }

    static ImmutableSet<? extends AnnotationMirror> getMapKeys(Element bindingElement) {
        return AnnotationMirrors.getAnnotatedAnnotations(bindingElement, MapKey.class);
    }

    public static DeclaredType getUnwrappedMapKeyType(final DeclaredType mapKeyAnnotationType, final Types types) {
        Preconditions.checkArgument((MoreTypes.asTypeElement(mapKeyAnnotationType).getKind() == ElementKind.ANNOTATION_TYPE ? 1 : 0) != 0, (String)"%s is not an annotation type", (Object[])new Object[]{mapKeyAnnotationType});
        final ExecutableElement onlyElement = (ExecutableElement)Iterables.getOnlyElement(ElementFilter.methodsIn(mapKeyAnnotationType.asElement().getEnclosedElements()));
        SimpleTypeVisitor6<DeclaredType, Void> keyTypeElementVisitor = new SimpleTypeVisitor6<DeclaredType, Void>(){

            @Override
            public DeclaredType visitArray(ArrayType t, Void p) {
                throw new IllegalArgumentException(mapKeyAnnotationType + "." + onlyElement.getSimpleName() + " cannot be an array");
            }

            @Override
            public DeclaredType visitPrimitive(PrimitiveType t, Void p) {
                return MoreTypes.asDeclared(types.boxedClass(t).asType());
            }

            @Override
            public DeclaredType visitDeclared(DeclaredType t, Void p) {
                return t;
            }
        };
        return (DeclaredType)keyTypeElementVisitor.visit(onlyElement.getReturnType());
    }

    public static ClassName getMapKeyCreatorClassName(TypeElement mapKeyType) {
        ClassName enclosingClassName = ClassName.fromTypeElement(mapKeyType);
        return enclosingClassName.topLevelClassName().peerNamed(enclosingClassName.classFileName() + "Creator");
    }

    static Snippet getMapKeySnippet(Element bindingElement) {
        AnnotationMirror mapKey = (AnnotationMirror)MapKeys.getMapKey(bindingElement).get();
        TypeElement mapKeyAnnotationType = MoreTypes.asTypeElement(mapKey.getAnnotationType());
        ClassName mapKeyCreator = MapKeys.getMapKeyCreatorClassName(mapKeyAnnotationType);
        if (mapKeyAnnotationType.getAnnotation(MapKey.class).unwrapValue()) {
            AnnotationValue memberToUnwrap = (AnnotationValue)Iterables.getOnlyElement(mapKey.getElementValues().values());
            return (Snippet)new MapKeySnippetExceptArrays(mapKeyCreator).visit(memberToUnwrap, memberToUnwrap);
        }
        return MapKeys.annotationSnippet(mapKey, new MapKeySnippet(mapKeyCreator));
    }

    private static Snippet annotationSnippet(AnnotationMirror mapKeyAnnotation, final MapKeySnippet mapKeySnippet) {
        return Snippet.format("%s.create%s(%s)", mapKeySnippet.mapKeyCreator, mapKeyAnnotation.getAnnotationType().asElement().getSimpleName(), Snippet.makeParametersSnippet(Iterables.transform(AnnotationMirrors.getAnnotationValuesWithDefaults(mapKeyAnnotation).entrySet(), (Function)new Function<Map.Entry<ExecutableElement, AnnotationValue>, Snippet>(){

            public Snippet apply(Map.Entry<ExecutableElement, AnnotationValue> entry) {
                return (Snippet)ARRAY_LITERAL_PREFIX.visit(entry.getKey().getReturnType(), mapKeySnippet.visit(entry.getValue(), entry.getValue()));
            }
        })));
    }

    private MapKeys() {
    }

    private static class MapKeySnippetExceptArrays
    extends MapKeySnippet {
        MapKeySnippetExceptArrays(ClassName mapKeyCreator) {
            super(mapKeyCreator);
        }

        @Override
        public Snippet visitArray(List<? extends AnnotationValue> values, AnnotationValue p) {
            throw new IllegalArgumentException("Cannot unwrap arrays");
        }
    }

    private static class MapKeySnippet
    extends SimpleAnnotationValueVisitor6<Snippet, AnnotationValue> {
        final ClassName mapKeyCreator;

        MapKeySnippet(ClassName mapKeyCreator) {
            this.mapKeyCreator = mapKeyCreator;
        }

        @Override
        public Snippet visitEnumConstant(VariableElement c, AnnotationValue p) {
            return Snippet.format("%s.%s", TypeNames.forTypeMirror(c.getEnclosingElement().asType()), c.getSimpleName());
        }

        @Override
        public Snippet visitAnnotation(AnnotationMirror a, AnnotationValue p) {
            return MapKeys.annotationSnippet(a, this);
        }

        @Override
        public Snippet visitType(TypeMirror t, AnnotationValue p) {
            return Snippet.format("%s.class", TypeNames.forTypeMirror(t));
        }

        @Override
        public Snippet visitString(String s, AnnotationValue p) {
            return Snippet.format("%s", p);
        }

        @Override
        public Snippet visitByte(byte b, AnnotationValue p) {
            return Snippet.format("(byte) %s", b);
        }

        @Override
        public Snippet visitChar(char c, AnnotationValue p) {
            return Snippet.format("%s", p);
        }

        @Override
        public Snippet visitDouble(double d, AnnotationValue p) {
            return Snippet.format("%sD", d);
        }

        @Override
        public Snippet visitFloat(float f, AnnotationValue p) {
            return Snippet.format("%sF", Float.valueOf(f));
        }

        @Override
        public Snippet visitInt(int i, AnnotationValue p) {
            return Snippet.format("(int) %s", i);
        }

        @Override
        public Snippet visitLong(long i, AnnotationValue p) {
            return Snippet.format("%sL", i);
        }

        @Override
        public Snippet visitShort(short s, AnnotationValue p) {
            return Snippet.format("(short) %s", s);
        }

        @Override
        protected Snippet defaultAction(Object o, AnnotationValue p) {
            return Snippet.format("%s", o);
        }

        @Override
        public Snippet visitArray(List<? extends AnnotationValue> values, AnnotationValue p) {
            ImmutableList.Builder snippets = ImmutableList.builder();
            for (int i = 0; i < values.size(); ++i) {
                snippets.add(this.visit(values.get(i), p));
            }
            return Snippet.format("{%s}", Snippet.makeParametersSnippet((Iterable<Snippet>)snippets.build()));
        }
    }
}

