/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import dagger.internal.codegen.AutoValue_MembersInjectionBinding;
import dagger.internal.codegen.AutoValue_MembersInjectionBinding_InjectionSite;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Key;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Comparator;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor6;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

abstract class MembersInjectionBinding
extends Binding {
    private static final Ordering<InjectionSite> INJECTION_ORDERING = new Ordering<InjectionSite>(){

        public int compare(InjectionSite left, InjectionSite right) {
            Preconditions.checkArgument((boolean)left.element().getEnclosingElement().equals(right.element().getEnclosingElement()));
            return ComparisonChain.start().compare((Comparable)((Object)left.element().getKind()), (Comparable)((Object)right.element().getKind())).compare(this.targetIndexInEnclosing(left), this.targetIndexInEnclosing(right)).result();
        }

        private int targetIndexInEnclosing(InjectionSite injectionSite) {
            return injectionSite.element().getEnclosingElement().getEnclosedElements().indexOf(injectionSite.element());
        }
    };

    MembersInjectionBinding() {
    }

    @Override
    abstract TypeElement bindingElement();

    abstract ImmutableSortedSet<InjectionSite> injectionSites();

    abstract Optional<DependencyRequest> parentInjectorRequest();

    Strategy injectionStrategy() {
        if (this.injectionSites().isEmpty()) {
            return this.parentInjectorRequest().isPresent() ? Strategy.DELEGATE : Strategy.NO_OP;
        }
        return Strategy.INJECT_MEMBERS;
    }

    MembersInjectionBinding withoutParentInjectorRequest() {
        return new AutoValue_MembersInjectionBinding(this.key(), this.dependencies(), this.implicitDependencies(), this.bindingPackage(), this.hasNonDefaultTypeParameters(), this.bindingElement(), this.injectionSites(), (Optional<DependencyRequest>)Optional.absent());
    }

    static final class Factory {
        private final Elements elements;
        private final Types types;
        private final Key.Factory keyFactory;
        private final DependencyRequest.Factory dependencyRequestFactory;

        Factory(Elements elements, Types types, Key.Factory keyFactory, DependencyRequest.Factory dependencyRequestFactory) {
            this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
            this.types = (Types)Preconditions.checkNotNull((Object)types);
            this.keyFactory = (Key.Factory)Preconditions.checkNotNull((Object)keyFactory);
            this.dependencyRequestFactory = (DependencyRequest.Factory)Preconditions.checkNotNull((Object)dependencyRequestFactory);
        }

        private InjectionSite injectionSiteForInjectMethod(ExecutableElement methodElement, DeclaredType containingType) {
            Preconditions.checkNotNull((Object)methodElement);
            Preconditions.checkArgument((boolean)methodElement.getKind().equals((Object)ElementKind.METHOD));
            Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(methodElement, Inject.class));
            ExecutableType resolved = MoreTypes.asExecutable(this.types.asMemberOf(containingType, methodElement));
            return new AutoValue_MembersInjectionBinding_InjectionSite(InjectionSite.Kind.METHOD, methodElement, this.dependencyRequestFactory.forRequiredResolvedVariables(containingType, methodElement.getParameters(), resolved.getParameterTypes()));
        }

        private InjectionSite injectionSiteForInjectField(VariableElement fieldElement, DeclaredType containingType) {
            Preconditions.checkNotNull((Object)fieldElement);
            Preconditions.checkArgument((boolean)fieldElement.getKind().equals((Object)ElementKind.FIELD));
            Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(fieldElement, Inject.class));
            TypeMirror resolved = this.types.asMemberOf(containingType, fieldElement);
            return new AutoValue_MembersInjectionBinding_InjectionSite(InjectionSite.Kind.FIELD, fieldElement, (ImmutableSet<DependencyRequest>)ImmutableSet.of((Object)this.dependencyRequestFactory.forRequiredResolvedVariable(containingType, fieldElement, resolved)));
        }

        MembersInjectionBinding unresolve(MembersInjectionBinding binding) {
            Preconditions.checkState((boolean)binding.hasNonDefaultTypeParameters());
            DeclaredType unresolved = MoreTypes.asDeclared(binding.bindingElement().asType());
            return this.forInjectedType(unresolved, (Optional<TypeMirror>)Optional.absent());
        }

        MembersInjectionBinding forInjectedType(DeclaredType type, Optional<TypeMirror> resolvedType) {
            if (!type.getTypeArguments().isEmpty() && resolvedType.isPresent()) {
                DeclaredType resolved = MoreTypes.asDeclared((TypeMirror)resolvedType.get());
                Preconditions.checkState((boolean)this.types.isSameType(this.types.erasure(resolved), this.types.erasure(type)), (String)"erased expected type: %s, erased actual type: %s", (Object[])new Object[]{this.types.erasure(resolved), this.types.erasure(type)});
                type = resolved;
            }
            TypeElement typeElement = MoreElements.asType(type.asElement());
            final DeclaredType resolved = type;
            ImmutableSortedSet.Builder injectionSitesBuilder = ImmutableSortedSet.orderedBy((Comparator)INJECTION_ORDERING);
            for (Element element : typeElement.getEnclosedElements()) {
                injectionSitesBuilder.addAll((Iterable)element.accept(new ElementKindVisitor6<Optional<InjectionSite>, Void>(Optional.absent()){

                    @Override
                    public Optional<InjectionSite> visitExecutableAsMethod(ExecutableElement e, Void p) {
                        return MoreElements.isAnnotationPresent(e, Inject.class) ? Optional.of((Object)Factory.this.injectionSiteForInjectMethod(e, resolved)) : Optional.absent();
                    }

                    @Override
                    public Optional<InjectionSite> visitVariableAsField(VariableElement e, Void p) {
                        return MoreElements.isAnnotationPresent(e, Inject.class) ? Optional.of((Object)Factory.this.injectionSiteForInjectField(e, resolved)) : Optional.absent();
                    }
                }, null).asSet());
            }
            ImmutableSortedSet injectionSites = injectionSitesBuilder.build();
            ImmutableSet immutableSet = FluentIterable.from((Iterable)injectionSites).transformAndConcat((Function)new Function<InjectionSite, Set<DependencyRequest>>(){

                public Set<DependencyRequest> apply(InjectionSite input) {
                    return input.dependencies();
                }
            }).toSet();
            Optional parentInjectorRequest = MoreTypes.nonObjectSuperclass(this.types, this.elements, type).transform((Function)new Function<DeclaredType, DependencyRequest>(){

                public DependencyRequest apply(DeclaredType input) {
                    return Factory.this.dependencyRequestFactory.forMembersInjectedType(input);
                }
            });
            Key key = this.keyFactory.forMembersInjectedType(type);
            return new AutoValue_MembersInjectionBinding(key, (ImmutableSet<DependencyRequest>)immutableSet, (Set<DependencyRequest>)new ImmutableSet.Builder().addAll((Iterable)parentInjectorRequest.asSet()).addAll((Iterable)immutableSet).build(), Binding.findBindingPackage(key), Binding.hasNonDefaultTypeParameters(typeElement, key.type(), this.types), typeElement, (ImmutableSortedSet<InjectionSite>)injectionSites, (Optional<DependencyRequest>)parentInjectorRequest);
        }
    }

    static abstract class InjectionSite {
        InjectionSite() {
        }

        abstract Kind kind();

        abstract Element element();

        abstract ImmutableSet<DependencyRequest> dependencies();

        static enum Kind {
            FIELD,
            METHOD;

        }
    }

    static enum Strategy {
        NO_OP,
        DELEGATE,
        INJECT_MEMBERS;

    }
}

