/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import dagger.MembersInjector;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.ComponentProcessor;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.DependencyRequestMapper;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.ClassWriter;
import dagger.internal.codegen.writer.ConstructorWriter;
import dagger.internal.codegen.writer.FieldWriter;
import dagger.internal.codegen.writer.JavaWriter;
import dagger.internal.codegen.writer.MethodWriter;
import dagger.internal.codegen.writer.ParameterizedTypeName;
import dagger.internal.codegen.writer.Snippet;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.TypeNames;
import dagger.internal.codegen.writer.TypeVariableName;
import dagger.internal.codegen.writer.VoidName;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class MembersInjectorGenerator
extends SourceFileGenerator<MembersInjectionBinding> {
    private final Elements elements;
    private final Types types;
    private final DependencyRequestMapper dependencyRequestMapper;

    MembersInjectorGenerator(Filer filer, Elements elements, Types types, DependencyRequestMapper dependencyRequestMapper) {
        super(filer);
        this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
        this.types = (Types)Preconditions.checkNotNull((Object)types);
        this.dependencyRequestMapper = dependencyRequestMapper;
    }

    @Override
    ClassName nameGeneratedType(MembersInjectionBinding binding) {
        return SourceFiles.membersInjectorNameForMembersInjectionBinding(binding);
    }

    @Override
    Iterable<? extends Element> getOriginatingElements(MembersInjectionBinding binding) {
        return FluentIterable.from(binding.injectionSites()).transform((Function)new Function<MembersInjectionBinding.InjectionSite, Element>(){

            public Element apply(MembersInjectionBinding.InjectionSite injectionSite) {
                return injectionSite.element();
            }
        }).toSet();
    }

    @Override
    Optional<? extends Element> getElementForErrorReporting(MembersInjectionBinding binding) {
        return Optional.of((Object)binding.bindingElement());
    }

    @Override
    ImmutableSet<JavaWriter> write(ClassName generatedTypeName, MembersInjectionBinding binding) {
        Preconditions.checkState((!binding.hasNonDefaultTypeParameters() ? 1 : 0) != 0);
        TypeName injectedTypeName = TypeNames.forTypeMirror(binding.key().type());
        JavaWriter writer = JavaWriter.inPackage(generatedTypeName.packageName());
        ClassWriter injectorWriter = writer.addClass(generatedTypeName.simpleName());
        ArrayList typeParameters = Lists.newArrayList();
        for (TypeParameterElement typeParameterElement : binding.bindingTypeElement().getTypeParameters()) {
            typeParameters.add(TypeVariableName.fromTypeParameterElement(typeParameterElement));
        }
        injectorWriter.addTypeParameters(typeParameters);
        injectorWriter.annotate(Generated.class).setValue(ComponentProcessor.class.getCanonicalName());
        injectorWriter.addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        ParameterizedTypeName implementedType = ParameterizedTypeName.create(MembersInjector.class, injectedTypeName);
        injectorWriter.addImplementedType(implementedType);
        ConstructorWriter constructorWriter = injectorWriter.addConstructor();
        constructorWriter.addModifiers(Modifier.PUBLIC, new Modifier[0]);
        MethodWriter injectMembersWriter = injectorWriter.addMethod(VoidName.VOID, "injectMembers");
        injectMembersWriter.addModifiers(Modifier.PUBLIC, new Modifier[0]);
        injectMembersWriter.annotate(Override.class);
        injectMembersWriter.addParameter(injectedTypeName, "instance");
        injectMembersWriter.body().addSnippet(Joiner.on((char)'\n').join((Object)"if (instance == null) {", (Object)"  throw new NullPointerException(\"Cannot inject members into a null reference\");", new Object[]{"}"}), new Object[0]);
        Optional<DeclaredType> supertype = MoreTypes.nonObjectSuperclass(this.types, this.elements, MoreTypes.asDeclared(binding.key().type()));
        if (supertype.isPresent()) {
            ParameterizedTypeName supertypeMemebersInjectorType = ParameterizedTypeName.create(MembersInjector.class, TypeNames.forTypeMirror((TypeMirror)supertype.get()));
            injectorWriter.addField(supertypeMemebersInjectorType, "supertypeInjector").addModifiers(Modifier.PRIVATE, Modifier.FINAL);
            constructorWriter.addParameter(supertypeMemebersInjectorType, "supertypeInjector");
            constructorWriter.body().addSnippet("assert supertypeInjector != null;", new Object[0]).addSnippet("this.supertypeInjector = supertypeInjector;", new Object[0]);
            injectMembersWriter.body().addSnippet("supertypeInjector.injectMembers(instance);", new Object[0]);
        }
        ImmutableMap<BindingKey, FrameworkField> fields = SourceFiles.generateBindingFieldsForDependencies(this.dependencyRequestMapper, (Iterable<? extends DependencyRequest>)ImmutableSet.copyOf(binding.dependencies()));
        ImmutableMap.Builder dependencyFieldsBuilder = ImmutableMap.builder();
        for (Map.Entry fieldEntry : fields.entrySet()) {
            FrameworkField bindingField = (FrameworkField)fieldEntry.getValue();
            TypeName fieldType = bindingField.frameworkType();
            FieldWriter field = injectorWriter.addField(fieldType, bindingField.name());
            field.addModifiers(Modifier.PRIVATE, Modifier.FINAL);
            constructorWriter.addParameter(field.type(), field.name());
            constructorWriter.body().addSnippet("assert %s != null;", field.name());
            constructorWriter.body().addSnippet("this.%1$s = %1$s;", field.name());
            dependencyFieldsBuilder.put(fieldEntry.getKey(), (Object)field);
        }
        MethodWriter createMethodWriter = injectorWriter.addMethod(implementedType, "create");
        createMethodWriter.addTypeParameters(typeParameters);
        createMethodWriter.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        Map<String, TypeName> params = constructorWriter.parameters();
        for (Map.Entry<String, TypeName> param : params.entrySet()) {
            createMethodWriter.addParameter(param.getValue(), param.getKey());
        }
        createMethodWriter.body().addSnippet("  return new %s(%s);", SourceFiles.parameterizedMembersInjectorNameForMembersInjectionBinding(binding), Joiner.on((String)", ").join(params.keySet()));
        ImmutableMap depedencyFields = dependencyFieldsBuilder.build();
        block7: for (MembersInjectionBinding.InjectionSite injectionSite : binding.injectionSites()) {
            switch (injectionSite.kind()) {
                case FIELD: {
                    DependencyRequest fieldDependency = (DependencyRequest)Iterables.getOnlyElement(injectionSite.dependencies());
                    FieldWriter singleField = (FieldWriter)depedencyFields.get((Object)fieldDependency.bindingKey());
                    injectMembersWriter.body().addSnippet("instance.%s = %s;", injectionSite.element().getSimpleName(), SourceFiles.frameworkTypeUsageStatement(Snippet.format(singleField.name(), new Object[0]), fieldDependency.kind()));
                    continue block7;
                }
                case METHOD: {
                    ImmutableList.Builder parameters = ImmutableList.builder();
                    for (DependencyRequest methodDependency : injectionSite.dependencies()) {
                        FieldWriter field = (FieldWriter)depedencyFields.get((Object)methodDependency.bindingKey());
                        parameters.add((Object)SourceFiles.frameworkTypeUsageStatement(Snippet.format(field.name(), new Object[0]), methodDependency.kind()));
                    }
                    injectMembersWriter.body().addSnippet("instance.%s(%s);", injectionSite.element().getSimpleName(), Snippet.makeParametersSnippet((Iterable<Snippet>)parameters.build()));
                    continue block7;
                }
            }
            throw new AssertionError();
        }
        return ImmutableSet.of((Object)writer);
    }
}

