/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.ResolvedBindings;
import java.util.ArrayDeque;
import java.util.Collection;

class MissingBindingSuggestions {
    static ImmutableList<String> forKey(BindingGraph topLevelGraph, BindingKey key) {
        ImmutableList.Builder resolutions = new ImmutableList.Builder();
        ArrayDeque<BindingGraph> graphsToTry = new ArrayDeque<BindingGraph>();
        graphsToTry.add(topLevelGraph);
        do {
            BindingGraph graph;
            ResolvedBindings bindings;
            if ((bindings = (ResolvedBindings)(graph = (BindingGraph)graphsToTry.removeLast()).resolvedBindings().get((Object)key)) == null || bindings.bindings().isEmpty()) {
                graphsToTry.addAll((Collection<BindingGraph>)graph.subgraphs().values());
                continue;
            }
            resolutions.add((Object)("A binding with matching key exists in component: " + graph.componentDescriptor().componentDefinitionType().getQualifiedName()));
        } while (!graphsToTry.isEmpty());
        return resolutions.build();
    }

    private MissingBindingSuggestions() {
    }
}

