/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.AutoValue_ModuleDescriptor;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.Util;
import dagger.producers.ProducerModule;
import dagger.producers.Produces;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

abstract class ModuleDescriptor {
    ModuleDescriptor() {
    }

    static final Function<ModuleDescriptor, TypeElement> getModuleElement() {
        return new Function<ModuleDescriptor, TypeElement>(){

            public TypeElement apply(ModuleDescriptor input) {
                return input.moduleElement();
            }
        };
    }

    abstract AnnotationMirror moduleAnnotation();

    abstract TypeElement moduleElement();

    abstract ImmutableSet<ModuleDescriptor> includedModules();

    abstract ImmutableSet<? extends ContributionBinding> bindings();

    abstract DefaultCreationStrategy defaultCreationStrategy();

    static final class Factory {
        private final Elements elements;
        private final ProvisionBinding.Factory provisionBindingFactory;
        private final ProductionBinding.Factory productionBindingFactory;

        Factory(Elements elements, ProvisionBinding.Factory provisionBindingFactory, ProductionBinding.Factory productionBindingFactory) {
            this.elements = elements;
            this.provisionBindingFactory = provisionBindingFactory;
            this.productionBindingFactory = productionBindingFactory;
        }

        ModuleDescriptor create(TypeElement moduleElement) {
            AnnotationMirror moduleAnnotation = (AnnotationMirror)Factory.getModuleAnnotation(moduleElement).get();
            ImmutableSet.Builder bindings = ImmutableSet.builder();
            for (ExecutableElement moduleMethod : ElementFilter.methodsIn(this.elements.getAllMembers(moduleElement))) {
                if (MoreElements.isAnnotationPresent(moduleMethod, Provides.class)) {
                    bindings.add((Object)this.provisionBindingFactory.forProvidesMethod(moduleMethod, moduleElement.asType()));
                }
                if (!MoreElements.isAnnotationPresent(moduleMethod, Produces.class)) continue;
                bindings.add((Object)this.productionBindingFactory.forProducesMethod(moduleMethod, moduleElement.asType()));
            }
            DefaultCreationStrategy defaultCreationStrategy = Util.componentCanMakeNewInstances(moduleElement) && moduleElement.getTypeParameters().isEmpty() ? DefaultCreationStrategy.CONSTRUCTED : DefaultCreationStrategy.PASSED;
            return new AutoValue_ModuleDescriptor(moduleAnnotation, moduleElement, (ImmutableSet<ModuleDescriptor>)ImmutableSet.copyOf(this.collectIncludedModules(new LinkedHashSet<ModuleDescriptor>(), moduleElement)), (ImmutableSet<? extends ContributionBinding>)bindings.build(), defaultCreationStrategy);
        }

        private static Optional<AnnotationMirror> getModuleAnnotation(TypeElement moduleElement) {
            return MoreElements.getAnnotationMirror(moduleElement, Module.class).or(MoreElements.getAnnotationMirror(moduleElement, ProducerModule.class));
        }

        private Set<ModuleDescriptor> collectIncludedModules(Set<ModuleDescriptor> includedModules, TypeElement moduleElement) {
            Optional<AnnotationMirror> moduleAnnotation;
            TypeMirror superclass = moduleElement.getSuperclass();
            if (!superclass.getKind().equals((Object)TypeKind.NONE)) {
                Verify.verify((boolean)superclass.getKind().equals((Object)TypeKind.DECLARED));
                TypeElement superclassElement = MoreTypes.asTypeElement(superclass);
                if (!superclassElement.getQualifiedName().contentEquals(Object.class.getCanonicalName())) {
                    this.collectIncludedModules(includedModules, superclassElement);
                }
            }
            if ((moduleAnnotation = Factory.getModuleAnnotation(moduleElement)).isPresent()) {
                for (TypeMirror moduleIncludesType : ConfigurationAnnotations.getModuleIncludes((AnnotationMirror)moduleAnnotation.get())) {
                    includedModules.add(this.create(MoreTypes.asTypeElement(moduleIncludesType)));
                }
            }
            return includedModules;
        }
    }

    static enum DefaultCreationStrategy {
        PASSED,
        CONSTRUCTED;

    }
}

