/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.ValidationReport;
import dagger.internal.codegen.Validator;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.Visibility;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

final class ModuleValidator
implements Validator<TypeElement> {
    private final Types types;
    private final Elements elements;
    private final Class<? extends Annotation> moduleClass;
    private final Class<? extends Annotation> methodClass;
    private final MethodSignatureFormatter methodSignatureFormatter;

    ModuleValidator(Types types, Elements elements, MethodSignatureFormatter methodSignatureFormatter, Class<? extends Annotation> moduleClass, Class<? extends Annotation> methodClass) {
        this.types = types;
        this.elements = elements;
        this.moduleClass = moduleClass;
        this.methodClass = methodClass;
        this.methodSignatureFormatter = methodSignatureFormatter;
    }

    @Override
    public ValidationReport<TypeElement> validate(TypeElement subject) {
        ValidationReport.Builder<TypeElement> builder = ValidationReport.Builder.about(subject);
        List<ExecutableElement> moduleMethods = ElementFilter.methodsIn(subject.getEnclosedElements());
        ArrayListMultimap allMethodsByName = ArrayListMultimap.create();
        ArrayListMultimap bindingMethodsByName = ArrayListMultimap.create();
        for (ExecutableElement moduleMethod : moduleMethods) {
            if (MoreElements.isAnnotationPresent(moduleMethod, this.methodClass)) {
                bindingMethodsByName.put((Object)moduleMethod.getSimpleName().toString(), (Object)moduleMethod);
            }
            allMethodsByName.put((Object)moduleMethod.getSimpleName().toString(), (Object)moduleMethod);
        }
        this.validateModuleVisibility(subject, builder);
        this.validateMethodsWithSameName(builder, (ListMultimap<String, ExecutableElement>)bindingMethodsByName);
        if (subject.getKind() != ElementKind.INTERFACE) {
            this.validateProvidesOverrides(subject, builder, (ListMultimap<String, ExecutableElement>)allMethodsByName, (ListMultimap<String, ExecutableElement>)bindingMethodsByName);
        }
        this.validateModifiers(subject, builder);
        this.validateReferencedModules(subject, builder);
        return builder.build();
    }

    private void validateModifiers(TypeElement subject, ValidationReport.Builder<TypeElement> builder) {
        if (!subject.getTypeParameters().isEmpty() && !subject.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            builder.addItem("Modules with type parameters must be abstract", subject);
        }
    }

    private void validateMethodsWithSameName(ValidationReport.Builder<TypeElement> builder, ListMultimap<String, ExecutableElement> bindingMethodsByName) {
        for (Map.Entry entry : bindingMethodsByName.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            for (ExecutableElement offendingMethod : (Collection)entry.getValue()) {
                builder.addItem(String.format("Cannot have more than one @%s method with the same name in a single module", this.methodClass.getSimpleName()), offendingMethod);
            }
        }
    }

    private void validateReferencedModules(TypeElement subject, ValidationReport.Builder<TypeElement> builder) {
        AnnotationMirror mirror = (AnnotationMirror)MoreElements.getAnnotationMirror(subject, this.moduleClass).get();
        ImmutableList<TypeMirror> includedTypes = ConfigurationAnnotations.getModuleIncludes(mirror);
        this.validateReferencedModules(subject, builder, includedTypes);
    }

    void validateReferencedModules(final TypeElement subject, final ValidationReport.Builder<TypeElement> builder, ImmutableList<TypeMirror> includedTypes) {
        for (TypeMirror includedType : includedTypes) {
            includedType.accept(new SimpleTypeVisitor6<Void, Void>(){

                @Override
                protected Void defaultAction(TypeMirror mirror, Void p) {
                    builder.addItem(mirror + " is not a valid module type.", subject);
                    return null;
                }

                @Override
                public Void visitDeclared(DeclaredType t, Void p) {
                    TypeElement element = MoreElements.asType(t.asElement());
                    if (!t.getTypeArguments().isEmpty()) {
                        builder.addItem(String.format("%s is listed as a module, but has type parameters", element.getQualifiedName()), subject);
                    }
                    if (!MoreElements.getAnnotationMirror(element, ModuleValidator.this.moduleClass).isPresent()) {
                        builder.addItem(String.format("%s is listed as a module, but is not annotated with @%s", element.getQualifiedName(), ModuleValidator.this.moduleClass.getSimpleName()), subject);
                    }
                    if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                        builder.addItem(String.format("%s is listed as a module, but is an abstract class or interface", element.getQualifiedName()), subject);
                    }
                    return null;
                }
            }, null);
        }
    }

    private void validateProvidesOverrides(TypeElement subject, ValidationReport.Builder<TypeElement> builder, ListMultimap<String, ExecutableElement> allMethodsByName, ListMultimap<String, ExecutableElement> bindingMethodsByName) {
        TypeElement currentClass = subject;
        TypeMirror objectType = this.elements.getTypeElement(Object.class.getCanonicalName()).asType();
        HashSet failedMethods = Sets.newHashSet();
        while (!this.types.isSameType(currentClass.getSuperclass(), objectType)) {
            currentClass = MoreElements.asType(this.types.asElement(currentClass.getSuperclass()));
            List<ExecutableElement> superclassMethods = ElementFilter.methodsIn(currentClass.getEnclosedElements());
            for (ExecutableElement superclassMethod : superclassMethods) {
                String name = superclassMethod.getSimpleName().toString();
                for (ExecutableElement providesMethod : bindingMethodsByName.get((Object)name)) {
                    if (failedMethods.contains(providesMethod) || !this.elements.overrides(providesMethod, superclassMethod, subject)) continue;
                    failedMethods.add(providesMethod);
                    builder.addItem(String.format("@%s methods may not override another method. Overrides: %s", this.methodClass.getSimpleName(), this.methodSignatureFormatter.format(superclassMethod)), providesMethod);
                }
                if (MoreElements.isAnnotationPresent(superclassMethod, this.methodClass)) {
                    for (ExecutableElement method : allMethodsByName.get((Object)name)) {
                        if (failedMethods.contains(method) || !this.elements.overrides(method, superclassMethod, subject)) continue;
                        failedMethods.add(method);
                        builder.addItem(String.format("@%s methods may not be overridden in modules. Overrides: %s", this.methodClass.getSimpleName(), this.methodSignatureFormatter.format(superclassMethod)), method);
                    }
                }
                allMethodsByName.put((Object)superclassMethod.getSimpleName().toString(), (Object)superclassMethod);
            }
        }
    }

    private void validateModuleVisibility(TypeElement moduleElement, ValidationReport.Builder<?> reportBuilder) {
        Visibility moduleVisibility = Visibility.ofElement(moduleElement);
        if (moduleVisibility.equals((Object)Visibility.PRIVATE)) {
            reportBuilder.addItem("Modules cannot be private.", moduleElement);
        } else if (Visibility.effectiveVisibilityOfElement(moduleElement).equals((Object)Visibility.PRIVATE)) {
            reportBuilder.addItem("Modules cannot be enclosed in private types.", moduleElement);
        }
        switch (moduleElement.getNestingKind()) {
            case ANONYMOUS: {
                throw new IllegalStateException("Can't apply @Module to an anonymous class");
            }
            case LOCAL: {
                throw new IllegalStateException("Local classes shouldn't show up in the processor");
            }
            case MEMBER: 
            case TOP_LEVEL: {
                ImmutableSet nonPublicModules;
                if (!moduleVisibility.equals((Object)Visibility.PUBLIC) || (nonPublicModules = FluentIterable.from(ConfigurationAnnotations.getModuleIncludes((AnnotationMirror)MoreElements.getAnnotationMirror(moduleElement, this.moduleClass).get())).transform((Function)new Function<TypeMirror, Element>(){

                    public Element apply(TypeMirror input) {
                        return ModuleValidator.this.types.asElement(input);
                    }
                }).filter((Predicate)new Predicate<Element>(){

                    public boolean apply(Element input) {
                        return Visibility.effectiveVisibilityOfElement(input).compareTo(Visibility.PUBLIC) < 0;
                    }
                }).toSet()).isEmpty()) break;
                reportBuilder.addItem(String.format("This module is public, but it includes non-public (or effectively non-public) modules. Either reduce the visibility of this module or make %s public.", ModuleValidator.formatListForErrorMessage(nonPublicModules.asList())), moduleElement);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private static String formatListForErrorMessage(List<?> things) {
        switch (things.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return things.get(0).toString();
            }
        }
        StringBuilder output = new StringBuilder();
        Joiner.on((String)", ").appendTo(output, things.subList(0, things.size() - 1));
        output.append(" and ").append(things.get(things.size() - 1));
        return output.toString();
    }
}

