/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.Provides;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.ComponentProcessor;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.DependencyRequestMapper;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.ClassWriter;
import dagger.internal.codegen.writer.ConstructorWriter;
import dagger.internal.codegen.writer.FieldWriter;
import dagger.internal.codegen.writer.JavaWriter;
import dagger.internal.codegen.writer.MethodWriter;
import dagger.internal.codegen.writer.ParameterizedTypeName;
import dagger.internal.codegen.writer.Snippet;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.TypeNames;
import dagger.producers.Produced;
import dagger.producers.Produces;
import dagger.producers.internal.AbstractProducer;
import dagger.producers.internal.Producers;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class ProducerFactoryGenerator
extends SourceFileGenerator<ProductionBinding> {
    private final DependencyRequestMapper dependencyRequestMapper;

    ProducerFactoryGenerator(Filer filer, DependencyRequestMapper dependencyRequestMapper) {
        super(filer);
        this.dependencyRequestMapper = dependencyRequestMapper;
    }

    @Override
    ClassName nameGeneratedType(ProductionBinding binding) {
        return SourceFiles.factoryNameForProductionBinding(binding);
    }

    @Override
    Iterable<? extends Element> getOriginatingElements(ProductionBinding binding) {
        return ImmutableSet.of((Object)binding.bindingElement());
    }

    @Override
    Optional<? extends Element> getElementForErrorReporting(ProductionBinding binding) {
        return Optional.of((Object)binding.bindingElement());
    }

    @Override
    ImmutableSet<JavaWriter> write(ClassName generatedTypeName, ProductionBinding binding) {
        TypeMirror keyType = binding.productionType().equals((Object)Provides.Type.MAP) ? Util.getProvidedValueTypeOfMap(MoreTypes.asDeclared(binding.key().type())) : binding.key().type();
        TypeName providedTypeName = TypeNames.forTypeMirror(keyType);
        ParameterizedTypeName futureTypeName = ParameterizedTypeName.create(ClassName.fromClass(ListenableFuture.class), providedTypeName);
        JavaWriter writer = JavaWriter.inPackage(generatedTypeName.packageName());
        ClassWriter factoryWriter = writer.addClass(generatedTypeName.simpleName());
        ConstructorWriter constructorWriter = factoryWriter.addConstructor();
        constructorWriter.addModifiers(Modifier.PUBLIC, new Modifier[0]);
        factoryWriter.addField(binding.bindingTypeElement(), "module").addModifiers(Modifier.PRIVATE, Modifier.FINAL);
        constructorWriter.addParameter(binding.bindingTypeElement(), "module");
        constructorWriter.body().addSnippet("assert module != null;", new Object[0]).addSnippet("this.module = module;", new Object[0]);
        factoryWriter.addField(Executor.class, "executor").addModifiers(Modifier.PRIVATE, Modifier.FINAL);
        constructorWriter.addParameter(Executor.class, "executor");
        constructorWriter.body().addSnippet("assert executor != null;", new Object[0]).addSnippet("this.executor = executor;", new Object[0]);
        factoryWriter.annotate(Generated.class).setValue(ComponentProcessor.class.getName());
        factoryWriter.addModifiers(Modifier.PUBLIC, new Modifier[0]);
        factoryWriter.addModifiers(Modifier.FINAL, new Modifier[0]);
        factoryWriter.setSuperclass(ParameterizedTypeName.create(AbstractProducer.class, providedTypeName));
        MethodWriter getMethodWriter = factoryWriter.addMethod(futureTypeName, "compute");
        getMethodWriter.annotate(Override.class);
        getMethodWriter.addModifiers(Modifier.PROTECTED, new Modifier[0]);
        final ImmutableMap<BindingKey, FrameworkField> fields = SourceFiles.generateBindingFieldsForDependencies(this.dependencyRequestMapper, binding.dependencies());
        for (FrameworkField bindingField : fields.values()) {
            TypeName fieldType = bindingField.frameworkType();
            FieldWriter field = factoryWriter.addField(fieldType, bindingField.name());
            field.addModifiers(Modifier.PRIVATE, Modifier.FINAL);
            constructorWriter.addParameter(field.type(), field.name());
            constructorWriter.body().addSnippet("assert %s != null;", field.name()).addSnippet("this.%1$s = %1$s;", field.name());
        }
        boolean returnsFuture = binding.bindingKind().equals((Object)ProductionBinding.Kind.FUTURE_PRODUCTION);
        ImmutableList asyncDependencies = FluentIterable.from(binding.dependencies()).filter((Predicate)new Predicate<DependencyRequest>(){

            public boolean apply(DependencyRequest dependency) {
                return ProducerFactoryGenerator.this.isAsyncDependency(dependency);
            }
        }).toList();
        for (DependencyRequest dependency : asyncDependencies) {
            ParameterizedTypeName futureType = ParameterizedTypeName.create(ClassName.fromClass(ListenableFuture.class), this.asyncDependencyType(dependency));
            String name = ((FrameworkField)fields.get((Object)dependency.bindingKey())).name();
            Snippet futureAccess = Snippet.format("%s.get()", name);
            getMethodWriter.body().addSnippet("%s %sFuture = %s;", futureType, name, dependency.kind().equals((Object)DependencyRequest.Kind.PRODUCED) ? Snippet.format("%s.createFutureProduced(%s)", ClassName.fromClass(Producers.class), futureAccess) : futureAccess);
        }
        if (asyncDependencies.isEmpty()) {
            ImmutableList.Builder parameterSnippets = ImmutableList.builder();
            for (DependencyRequest dependency : binding.dependencies()) {
                parameterSnippets.add((Object)SourceFiles.frameworkTypeUsageStatement(Snippet.format(((FrameworkField)fields.get((Object)dependency.bindingKey())).name(), new Object[0]), dependency.kind()));
            }
            boolean wrapWithFuture = false;
            Snippet invocationSnippet = this.getInvocationSnippet(false, binding, (ImmutableList<Snippet>)parameterSnippets.build());
            TypeName callableReturnType = returnsFuture ? futureTypeName : providedTypeName;
            Snippet throwsClause = this.getThrowsClause((List<? extends TypeMirror>)binding.thrownTypes());
            Snippet callableSnippet = Snippet.format(Joiner.on((char)'\n').join((Object)"new %1$s<%2$s>() {", (Object)"  @Override public %2$s call() %3$s{", new Object[]{"    return %4$s;", "  }", "}"}), ClassName.fromClass(Callable.class), callableReturnType, throwsClause, invocationSnippet);
            getMethodWriter.body().addSnippet("%s future = %s.submitToExecutor(%s, executor);", ParameterizedTypeName.create(ClassName.fromClass(ListenableFuture.class), callableReturnType), ClassName.fromClass(Producers.class), callableSnippet);
            getMethodWriter.body().addSnippet("return %s;", returnsFuture ? Snippet.format("%s.dereference(future)", ClassName.fromClass(Futures.class)) : "future");
        } else {
            Snippet transformSnippet;
            Snippet futureSnippet;
            if (asyncDependencies.size() == 1) {
                DependencyRequest asyncDependency = (DependencyRequest)Iterables.getOnlyElement((Iterable)asyncDependencies);
                futureSnippet = Snippet.format("%s", ((FrameworkField)fields.get((Object)asyncDependency.bindingKey())).name() + "Future");
                String argName = asyncDependency.requestElement().getSimpleName().toString();
                ImmutableList.Builder parameterSnippets = ImmutableList.builder();
                for (DependencyRequest dependency : binding.dependencies()) {
                    if (dependency == asyncDependency) {
                        parameterSnippets.add((Object)Snippet.format("%s", argName));
                        continue;
                    }
                    parameterSnippets.add((Object)SourceFiles.frameworkTypeUsageStatement(Snippet.format(((FrameworkField)fields.get((Object)dependency.bindingKey())).name(), new Object[0]), dependency.kind()));
                }
                boolean wrapWithFuture = !returnsFuture;
                Snippet invocationSnippet = this.getInvocationSnippet(wrapWithFuture, binding, (ImmutableList<Snippet>)parameterSnippets.build());
                Snippet throwsClause = this.getThrowsClause((List<? extends TypeMirror>)binding.thrownTypes());
                transformSnippet = Snippet.format(Joiner.on((char)'\n').join((Object)"new %1$s<%2$s, %3$s>() {", (Object)"  @Override public %4$s apply(%2$s %5$s) %6$s{", new Object[]{"    return %7$s;", "  }", "}"}), ClassName.fromClass(AsyncFunction.class), this.asyncDependencyType(asyncDependency), providedTypeName, futureTypeName, argName, throwsClause, invocationSnippet);
            } else {
                futureSnippet = Snippet.format("%s.<%s>allAsList(%s)", ClassName.fromClass(Futures.class), ClassName.fromClass(Object.class), Joiner.on((String)",").join((Iterable)FluentIterable.from((Iterable)asyncDependencies).transform((Function)new Function<DependencyRequest, String>(){

                    public String apply(DependencyRequest dependency) {
                        return ((FrameworkField)fields.get((Object)dependency.bindingKey())).name() + "Future";
                    }
                })));
                ImmutableList<Snippet> parameterSnippets = this.getParameterSnippets(binding, fields, "args");
                boolean wrapWithFuture = !returnsFuture;
                Snippet invocationSnippet = this.getInvocationSnippet(wrapWithFuture, binding, parameterSnippets);
                ParameterizedTypeName listOfObject = ParameterizedTypeName.create(ClassName.fromClass(List.class), ClassName.fromClass(Object.class));
                Snippet throwsClause = this.getThrowsClause((List<? extends TypeMirror>)binding.thrownTypes());
                transformSnippet = Snippet.format(Joiner.on((char)'\n').join((Object)"new %1$s<%2$s, %3$s>() {", (Object)"  @SuppressWarnings(\"unchecked\")  // safe by specification", new Object[]{"  @Override public %4$s apply(%2$s args) %5$s{", "    return %6$s;", "  }", "}"}), ClassName.fromClass(AsyncFunction.class), listOfObject, providedTypeName, futureTypeName, throwsClause, invocationSnippet);
            }
            getMethodWriter.body().addSnippet("return %s.%s(%s, %s, executor);", ClassName.fromClass(Futures.class), "transform", futureSnippet, transformSnippet);
        }
        return ImmutableSet.of((Object)writer);
    }

    private boolean isAsyncDependency(DependencyRequest dependency) {
        switch (dependency.kind()) {
            case INSTANCE: 
            case PRODUCED: {
                return true;
            }
        }
        return false;
    }

    private TypeName asyncDependencyType(DependencyRequest dependency) {
        TypeName keyName = TypeNames.forTypeMirror(dependency.key().type());
        switch (dependency.kind()) {
            case INSTANCE: {
                return keyName;
            }
            case PRODUCED: {
                return ParameterizedTypeName.create(ClassName.fromClass(Produced.class), keyName);
            }
        }
        throw new AssertionError();
    }

    private ImmutableList<Snippet> getParameterSnippets(ProductionBinding binding, ImmutableMap<BindingKey, FrameworkField> fields, String listArgName) {
        int argIndex = 0;
        ImmutableList.Builder snippets = ImmutableList.builder();
        for (DependencyRequest dependency : binding.dependencies()) {
            if (this.isAsyncDependency(dependency)) {
                snippets.add((Object)Snippet.format("(%s) %s.get(%s)", this.asyncDependencyType(dependency), listArgName, argIndex));
                ++argIndex;
                continue;
            }
            snippets.add((Object)SourceFiles.frameworkTypeUsageStatement(Snippet.format(((FrameworkField)fields.get((Object)dependency.bindingKey())).name(), new Object[0]), dependency.kind()));
        }
        return snippets.build();
    }

    private Snippet getInvocationSnippet(boolean wrapWithFuture, ProductionBinding binding, ImmutableList<Snippet> parameterSnippets) {
        Snippet moduleSnippet = Snippet.format("module.%s(%s)", binding.bindingElement().getSimpleName(), Snippet.makeParametersSnippet(parameterSnippets));
        if (wrapWithFuture) {
            moduleSnippet = Snippet.format("%s.immediateFuture(%s)", ClassName.fromClass(Futures.class), moduleSnippet);
        }
        if (binding.productionType().equals((Object)Produces.Type.SET)) {
            if (binding.bindingKind().equals((Object)ProductionBinding.Kind.FUTURE_PRODUCTION)) {
                return Snippet.format("%s.createFutureSingletonSet(%s)", ClassName.fromClass(Producers.class), moduleSnippet);
            }
            return Snippet.format("%s.of(%s)", ClassName.fromClass(ImmutableSet.class), moduleSnippet);
        }
        return moduleSnippet;
    }

    private Snippet getThrowsClause(List<? extends TypeMirror> thrownTypes) {
        if (thrownTypes.isEmpty()) {
            return Snippet.format("", new Object[0]);
        }
        return Snippet.format("throws %s ", Snippet.makeParametersSnippet((Iterable<Snippet>)FluentIterable.from(thrownTypes).transform((Function)new Function<TypeMirror, Snippet>(){

            public Snippet apply(TypeMirror thrownType) {
                return Snippet.format("%s", TypeNames.forTypeMirror(thrownType));
            }
        }).toList()));
    }
}

