/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import dagger.internal.codegen.ModuleValidator;
import dagger.internal.codegen.ProducerFactoryGenerator;
import dagger.internal.codegen.ProducesMethodValidator;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.SourceFileGenerationException;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProducerModule;
import dagger.producers.Produces;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.SuperficialValidation;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class ProducerModuleProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;
    private final ModuleValidator moduleValidator;
    private final ProducesMethodValidator producesMethodValidator;
    private final ProductionBinding.Factory productionBindingFactory;
    private final ProducerFactoryGenerator factoryGenerator;
    private final Set<Element> processedModuleElements = Sets.newLinkedHashSet();

    ProducerModuleProcessingStep(Messager messager, ModuleValidator moduleValidator, ProducesMethodValidator producesMethodValidator, ProductionBinding.Factory productionBindingFactory, ProducerFactoryGenerator factoryGenerator) {
        this.messager = messager;
        this.moduleValidator = moduleValidator;
        this.producesMethodValidator = producesMethodValidator;
        this.productionBindingFactory = productionBindingFactory;
        this.factoryGenerator = factoryGenerator;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(Produces.class, ProducerModule.class);
    }

    @Override
    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        ImmutableSet.Builder validProducesMethodsBuilder = ImmutableSet.builder();
        for (Element producesElement : elementsByAnnotation.get(Produces.class)) {
            if (!producesElement.getKind().equals((Object)ElementKind.METHOD)) continue;
            ExecutableElement producesMethodElement = (ExecutableElement)producesElement;
            ValidationReport<ExecutableElement> methodReport = this.producesMethodValidator.validate(producesMethodElement);
            methodReport.printMessagesTo(this.messager);
            if (!methodReport.isClean()) continue;
            validProducesMethodsBuilder.add((Object)producesMethodElement);
        }
        ImmutableSet validProducesMethods = validProducesMethodsBuilder.build();
        for (Element moduleElement : Sets.difference((Set)elementsByAnnotation.get(ProducerModule.class), this.processedModuleElements)) {
            if (!SuperficialValidation.validateElement(moduleElement)) continue;
            ValidationReport<TypeElement> report = this.moduleValidator.validate(MoreElements.asType(moduleElement));
            report.printMessagesTo(this.messager);
            if (report.isClean()) {
                ImmutableSet.Builder moduleProducesMethodsBuilder = ImmutableSet.builder();
                List<ExecutableElement> moduleMethods = ElementFilter.methodsIn(moduleElement.getEnclosedElements());
                for (ExecutableElement methodElement : moduleMethods) {
                    if (!MoreElements.isAnnotationPresent(methodElement, Produces.class)) continue;
                    moduleProducesMethodsBuilder.add((Object)methodElement);
                }
                ImmutableSet moduleProducesMethods = moduleProducesMethodsBuilder.build();
                if (Sets.difference((Set)moduleProducesMethods, (Set)validProducesMethods).isEmpty()) {
                    ImmutableSet bindings = FluentIterable.from((Iterable)moduleProducesMethods).transform((Function)new Function<ExecutableElement, ProductionBinding>(){

                        public ProductionBinding apply(ExecutableElement producesMethod) {
                            return ProducerModuleProcessingStep.this.productionBindingFactory.forProducesMethod(producesMethod, producesMethod.getEnclosingElement().asType());
                        }
                    }).toSet();
                    try {
                        for (ProductionBinding binding : bindings) {
                            this.factoryGenerator.generate(binding);
                        }
                    }
                    catch (SourceFileGenerationException e) {
                        e.printMessageTo(this.messager);
                    }
                }
            }
            this.processedModuleElements.add(moduleElement);
        }
        return ImmutableSet.of();
    }
}

