/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.AbstractComponentProcessingStep;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingGraphValidator;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentGenerator;
import dagger.internal.codegen.ProductionComponentValidator;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProductionComponent;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

final class ProductionComponentProcessingStep
extends AbstractComponentProcessingStep {
    private final Messager messager;
    private final ProductionComponentValidator componentValidator;
    private final ComponentDescriptor.Factory componentDescriptorFactory;

    ProductionComponentProcessingStep(Messager messager, ProductionComponentValidator componentValidator, BindingGraphValidator bindingGraphValidator, ComponentDescriptor.Factory componentDescriptorFactory, BindingGraph.Factory bindingGraphFactory, ComponentGenerator componentGenerator) {
        super(messager, bindingGraphValidator, bindingGraphFactory, componentGenerator);
        this.messager = messager;
        this.componentValidator = componentValidator;
        this.componentDescriptorFactory = componentDescriptorFactory;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(ProductionComponent.class);
    }

    protected ImmutableSet<ComponentDescriptor> componentDescriptors(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        ImmutableSet.Builder componentDescriptors = ImmutableSet.builder();
        Set componentElements = elementsByAnnotation.get(ProductionComponent.class);
        for (Element element : componentElements) {
            TypeElement componentTypeElement = MoreElements.asType(element);
            ValidationReport<TypeElement> componentReport = this.componentValidator.validate(componentTypeElement);
            componentReport.printMessagesTo(this.messager);
            if (!componentReport.isClean()) continue;
            componentDescriptors.add((Object)this.componentDescriptorFactory.forProductionComponent(componentTypeElement));
        }
        return componentDescriptors.build();
    }
}

