/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import dagger.Module;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ValidationReport;
import dagger.internal.codegen.Validator;
import dagger.producers.ProducerModule;
import dagger.producers.ProductionComponent;
import dagger.shaded.auto.common.MoreElements;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor6;

final class ProductionComponentValidator
implements Validator<TypeElement> {
    ProductionComponentValidator() {
    }

    @Override
    public ValidationReport<TypeElement> validate(final TypeElement subject) {
        final ValidationReport.Builder<TypeElement> builder = ValidationReport.Builder.about(subject);
        if (!(subject.getKind().equals((Object)ElementKind.INTERFACE) || subject.getKind().equals((Object)ElementKind.CLASS) && subject.getModifiers().contains((Object)Modifier.ABSTRACT))) {
            builder.addItem("@ProductionComponent may only be applied to an interface or abstract class", subject);
        }
        AnnotationMirror componentMirror = (AnnotationMirror)MoreElements.getAnnotationMirror(subject, ProductionComponent.class).get();
        ImmutableList<TypeMirror> moduleTypes = ConfigurationAnnotations.getComponentModules(componentMirror);
        for (TypeMirror moduleType : moduleTypes) {
            moduleType.accept(new SimpleTypeVisitor6<Void, Void>(){

                @Override
                protected Void defaultAction(TypeMirror mirror, Void p) {
                    builder.addItem(mirror + " is not a valid module type.", subject);
                    return null;
                }

                @Override
                public Void visitDeclared(DeclaredType t, Void p) {
                    Preconditions.checkState((boolean)t.getTypeArguments().isEmpty());
                    TypeElement moduleElement = MoreElements.asType(t.asElement());
                    if (!MoreElements.getAnnotationMirror(moduleElement, Module.class).isPresent() && !MoreElements.getAnnotationMirror(moduleElement, ProducerModule.class).isPresent()) {
                        builder.addItem(moduleElement.getQualifiedName() + " is listed as a module, but is not annotated with @Module or @ProducerModule", subject);
                    }
                    return null;
                }
            }, null);
        }
        return builder.build();
    }
}

