/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dagger.Provides;
import dagger.internal.codegen.AutoValue_ProvisionBinding;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.Util;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

abstract class ProvisionBinding
extends ContributionBinding {
    ProvisionBinding() {
    }

    @Override
    Set<DependencyRequest> implicitDependencies() {
        if (!this.memberInjectionRequest().isPresent()) {
            return this.dependencies();
        }
        return Sets.union((Set)this.memberInjectionRequest().asSet(), this.dependencies());
    }

    abstract Kind bindingKind();

    abstract Provides.Type provisionType();

    Optional<AnnotationMirror> scope() {
        return Util.unwrapOptionalEquivalence(this.wrappedScope());
    }

    abstract Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedScope();

    abstract Optional<DependencyRequest> memberInjectionRequest();

    @Override
    ContributionBinding.BindingType bindingType() {
        switch (this.provisionType()) {
            case SET: 
            case SET_VALUES: {
                return ContributionBinding.BindingType.SET;
            }
            case MAP: {
                return ContributionBinding.BindingType.MAP;
            }
            case UNIQUE: {
                return ContributionBinding.BindingType.UNIQUE;
            }
        }
        throw new IllegalStateException("Unknown provision type: " + this.provisionType());
    }

    @Override
    boolean isSyntheticBinding() {
        return this.bindingKind().equals((Object)Kind.SYNTHETIC_PROVISON);
    }

    @Override
    Class<?> frameworkClass() {
        return Provider.class;
    }

    FactoryCreationStrategy factoryCreationStrategy() {
        if (this.bindingKind().equals((Object)Kind.INJECTION) && this.implicitDependencies().isEmpty()) {
            return FactoryCreationStrategy.ENUM_INSTANCE;
        }
        if (this.bindingKind().equals((Object)Kind.PROVISION) && this.implicitDependencies().isEmpty() && this.bindingElement().getModifiers().contains((Object)Modifier.STATIC)) {
            return FactoryCreationStrategy.ENUM_INSTANCE;
        }
        return FactoryCreationStrategy.CLASS_CONSTRUCTOR;
    }

    static final class Factory {
        private final Elements elements;
        private final Types types;
        private final Key.Factory keyFactory;
        private final DependencyRequest.Factory dependencyRequestFactory;
        private static final ImmutableSet<ElementKind> MEMBER_KINDS = Sets.immutableEnumSet((Enum)ElementKind.METHOD, (Enum[])new ElementKind[]{ElementKind.FIELD});

        Factory(Elements elements, Types types, Key.Factory keyFactory, DependencyRequest.Factory dependencyRequestFactory) {
            this.elements = elements;
            this.types = types;
            this.keyFactory = keyFactory;
            this.dependencyRequestFactory = dependencyRequestFactory;
        }

        ProvisionBinding unresolve(ProvisionBinding binding) {
            Preconditions.checkState((boolean)binding.hasNonDefaultTypeParameters());
            return this.forInjectConstructor((ExecutableElement)binding.bindingElement(), (Optional<TypeMirror>)Optional.absent());
        }

        ProvisionBinding forInjectConstructor(ExecutableElement constructorElement, Optional<TypeMirror> resolvedType) {
            Key key;
            Preconditions.checkNotNull((Object)constructorElement);
            Preconditions.checkArgument((boolean)constructorElement.getKind().equals((Object)ElementKind.CONSTRUCTOR));
            Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(constructorElement, Inject.class));
            Preconditions.checkArgument((!InjectionAnnotations.getQualifier(constructorElement).isPresent() ? 1 : 0) != 0);
            ExecutableType cxtorType = MoreTypes.asExecutable(constructorElement.asType());
            DeclaredType enclosingCxtorType = MoreTypes.asDeclared(constructorElement.getEnclosingElement().asType());
            if (!enclosingCxtorType.getTypeArguments().isEmpty() && resolvedType.isPresent()) {
                DeclaredType resolved = MoreTypes.asDeclared((TypeMirror)resolvedType.get());
                Preconditions.checkState((boolean)this.types.isSameType(this.types.erasure(resolved), this.types.erasure(enclosingCxtorType)), (String)"erased expected type: %s, erased actual type: %s", (Object[])new Object[]{this.types.erasure(resolved), this.types.erasure(enclosingCxtorType)});
                cxtorType = MoreTypes.asExecutable(this.types.asMemberOf(resolved, constructorElement));
                enclosingCxtorType = resolved;
            }
            Preconditions.checkArgument((!(key = this.keyFactory.forInjectConstructorWithResolvedType(enclosingCxtorType)).qualifier().isPresent() ? 1 : 0) != 0);
            ImmutableSet<DependencyRequest> dependencies = this.dependencyRequestFactory.forRequiredResolvedVariables(enclosingCxtorType, constructorElement.getParameters(), cxtorType.getParameterTypes());
            Optional<DependencyRequest> membersInjectionRequest = this.membersInjectionRequest(enclosingCxtorType);
            Optional<AnnotationMirror> scope = InjectionAnnotations.getScopeAnnotation(constructorElement.getEnclosingElement());
            TypeElement bindingTypeElement = MoreElements.asType(constructorElement.getEnclosingElement());
            return new AutoValue_ProvisionBinding(key, constructorElement, dependencies, Binding.findBindingPackage(key), Binding.hasNonDefaultTypeParameters(bindingTypeElement, key.type(), this.types), (Optional<DeclaredType>)Optional.absent(), (Optional<TypeElement>)Optional.absent(), Kind.INJECTION, Provides.Type.UNIQUE, Util.wrapOptionalInEquivalence(AnnotationMirrors.equivalence(), scope), membersInjectionRequest);
        }

        private Optional<DependencyRequest> membersInjectionRequest(DeclaredType type) {
            TypeElement typeElement = MoreElements.asType(type.asElement());
            if (!this.types.isSameType(this.elements.getTypeElement(Object.class.getCanonicalName()).asType(), typeElement.getSuperclass())) {
                return Optional.of((Object)this.dependencyRequestFactory.forMembersInjectedType(type));
            }
            for (Element element : typeElement.getEnclosedElements()) {
                if (!MEMBER_KINDS.contains((Object)element.getKind()) || !MoreElements.isAnnotationPresent(element, Inject.class)) continue;
                return Optional.of((Object)this.dependencyRequestFactory.forMembersInjectedType(type));
            }
            return Optional.absent();
        }

        ProvisionBinding forProvidesMethod(ExecutableElement providesMethod, TypeMirror contributedBy) {
            Preconditions.checkNotNull((Object)providesMethod);
            Preconditions.checkArgument((boolean)providesMethod.getKind().equals((Object)ElementKind.METHOD));
            Preconditions.checkArgument((boolean)contributedBy.getKind().equals((Object)TypeKind.DECLARED));
            Provides providesAnnotation = providesMethod.getAnnotation(Provides.class);
            Preconditions.checkArgument((providesAnnotation != null ? 1 : 0) != 0);
            DeclaredType declaredContainer = MoreTypes.asDeclared(contributedBy);
            ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(declaredContainer, providesMethod));
            Key key = this.keyFactory.forProvidesMethod(resolvedMethod, providesMethod);
            ImmutableSet<DependencyRequest> dependencies = this.dependencyRequestFactory.forRequiredResolvedVariables(declaredContainer, providesMethod.getParameters(), resolvedMethod.getParameterTypes());
            Optional<AnnotationMirror> scope = InjectionAnnotations.getScopeAnnotation(providesMethod);
            return new AutoValue_ProvisionBinding(key, providesMethod, dependencies, Binding.findBindingPackage(key), false, ConfigurationAnnotations.getNullableType(providesMethod), (Optional<TypeElement>)Optional.of((Object)MoreTypes.asTypeElement(declaredContainer)), Kind.PROVISION, providesAnnotation.type(), Util.wrapOptionalInEquivalence(AnnotationMirrors.equivalence(), scope), (Optional<DependencyRequest>)Optional.absent());
        }

        ProvisionBinding forImplicitMapBinding(DependencyRequest explicitRequest, DependencyRequest implicitRequest) {
            Preconditions.checkNotNull((Object)explicitRequest);
            Preconditions.checkNotNull((Object)implicitRequest);
            ImmutableSet dependencies = ImmutableSet.of((Object)implicitRequest);
            Optional<AnnotationMirror> scope = InjectionAnnotations.getScopeAnnotation(implicitRequest.requestElement());
            return new AutoValue_ProvisionBinding(explicitRequest.key(), implicitRequest.requestElement(), (ImmutableSet<DependencyRequest>)dependencies, Binding.findBindingPackage(explicitRequest.key()), false, (Optional<DeclaredType>)Optional.absent(), (Optional<TypeElement>)Optional.absent(), Kind.SYNTHETIC_PROVISON, Provides.Type.MAP, Util.wrapOptionalInEquivalence(AnnotationMirrors.equivalence(), scope), (Optional<DependencyRequest>)Optional.absent());
        }

        ProvisionBinding forComponent(TypeElement componentDefinitionType) {
            Preconditions.checkNotNull((Object)componentDefinitionType);
            return new AutoValue_ProvisionBinding(this.keyFactory.forComponent(componentDefinitionType.asType()), componentDefinitionType, (ImmutableSet<DependencyRequest>)ImmutableSet.of(), (Optional<String>)Optional.absent(), false, (Optional<DeclaredType>)Optional.absent(), (Optional<TypeElement>)Optional.absent(), Kind.COMPONENT, Provides.Type.UNIQUE, (Optional<Equivalence.Wrapper<AnnotationMirror>>)Optional.absent(), (Optional<DependencyRequest>)Optional.absent());
        }

        ProvisionBinding forComponentMethod(ExecutableElement componentMethod) {
            Preconditions.checkNotNull((Object)componentMethod);
            Preconditions.checkArgument((boolean)componentMethod.getKind().equals((Object)ElementKind.METHOD));
            Preconditions.checkArgument((boolean)componentMethod.getParameters().isEmpty());
            Optional<AnnotationMirror> scope = InjectionAnnotations.getScopeAnnotation(componentMethod);
            return new AutoValue_ProvisionBinding(this.keyFactory.forComponentMethod(componentMethod), componentMethod, (ImmutableSet<DependencyRequest>)ImmutableSet.of(), (Optional<String>)Optional.absent(), false, ConfigurationAnnotations.getNullableType(componentMethod), (Optional<TypeElement>)Optional.absent(), Kind.COMPONENT_PROVISION, Provides.Type.UNIQUE, Util.wrapOptionalInEquivalence(AnnotationMirrors.equivalence(), scope), (Optional<DependencyRequest>)Optional.absent());
        }
    }

    static enum FactoryCreationStrategy {
        ENUM_INSTANCE,
        CLASS_CONSTRUCTOR;

    }

    static enum Kind {
        INJECTION,
        PROVISION,
        SYNTHETIC_PROVISON,
        COMPONENT,
        COMPONENT_PROVISION;

    }
}

