/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.SourceFileGenerationException;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.JavaWriter;
import dagger.internal.codegen.writer.TypeWriter;
import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;

abstract class SourceFileGenerator<T> {
    private final Filer filer;

    SourceFileGenerator(Filer filer) {
        this.filer = (Filer)Preconditions.checkNotNull((Object)filer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void generate(T input) throws SourceFileGenerationException {
        ClassName generatedTypeName = this.nameGeneratedType(input);
        ImmutableSet originatingElements = ImmutableSet.copyOf(this.getOriginatingElements(input));
        try {
            ImmutableSet<JavaWriter> writers = this.write(generatedTypeName, input);
            for (JavaWriter javaWriter : writers) {
                try {
                    javaWriter.file(this.filer, (Iterable<? extends Element>)originatingElements);
                }
                catch (IOException e) {
                    throw new SourceFileGenerationException(SourceFileGenerator.getNamesForWriters(javaWriter.getTypeWriters()), (Throwable)e, this.getElementForErrorReporting(input));
                    return;
                }
            }
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, SourceFileGenerationException.class);
            throw new SourceFileGenerationException((Iterable<ClassName>)ImmutableList.of(), (Throwable)e, this.getElementForErrorReporting(input));
        }
    }

    private static Iterable<ClassName> getNamesForWriters(Iterable<TypeWriter> typeWriters) {
        return Iterables.transform(typeWriters, (Function)new Function<TypeWriter, ClassName>(){

            public ClassName apply(TypeWriter input) {
                return input.name();
            }
        });
    }

    abstract ClassName nameGeneratedType(T var1);

    abstract Iterable<? extends Element> getOriginatingElements(T var1);

    abstract Optional<? extends Element> getElementForErrorReporting(T var1);

    abstract ImmutableSet<JavaWriter> write(ClassName var1, T var2);
}

