/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

final class Util {
    public static TypeMirror getProvidedValueTypeOfMap(DeclaredType mapType) {
        Preconditions.checkState((boolean)MoreTypes.isTypeOf(Map.class, mapType), (String)"%s is not a Map.", (Object[])new Object[]{mapType});
        return MoreTypes.asDeclared(mapType.getTypeArguments().get(1)).getTypeArguments().get(0);
    }

    public static TypeMirror getValueTypeOfMap(DeclaredType mapType) {
        Preconditions.checkState((boolean)MoreTypes.isTypeOf(Map.class, mapType), (String)"%s is not a Map.", (Object[])new Object[]{mapType});
        List<? extends TypeMirror> mapArgs = mapType.getTypeArguments();
        return mapArgs.get(1);
    }

    public static DeclaredType getKeyTypeOfMap(DeclaredType mapType) {
        Preconditions.checkState((boolean)MoreTypes.isTypeOf(Map.class, mapType), (String)"%s is not a Map.", (Object[])new Object[]{mapType});
        List<? extends TypeMirror> mapArgs = mapType.getTypeArguments();
        return MoreTypes.asDeclared(mapArgs.get(0));
    }

    static <T> Optional<Equivalence.Wrapper<T>> wrapOptionalInEquivalence(Equivalence<T> equivalence, Optional<T> optional) {
        return optional.isPresent() ? Optional.of((Object)equivalence.wrap(optional.get())) : Optional.absent();
    }

    static <T> Optional<T> unwrapOptionalEquivalence(Optional<Equivalence.Wrapper<T>> wrappedOptional) {
        return wrappedOptional.isPresent() ? Optional.of((Object)((Equivalence.Wrapper)wrappedOptional.get()).get()) : Optional.absent();
    }

    private static boolean requiresEnclosingInstance(TypeElement typeElement) {
        switch (typeElement.getNestingKind()) {
            case TOP_LEVEL: {
                return false;
            }
            case MEMBER: {
                return !typeElement.getModifiers().contains((Object)Modifier.STATIC);
            }
            case ANONYMOUS: 
            case LOCAL: {
                return true;
            }
        }
        throw new AssertionError((Object)("TypeElement cannot have nesting kind: " + (Object)((Object)typeElement.getNestingKind())));
    }

    static boolean componentCanMakeNewInstances(TypeElement typeElement) {
        switch (typeElement.getKind()) {
            case CLASS: {
                break;
            }
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: {
                return false;
            }
            default: {
                throw new AssertionError((Object)("TypeElement cannot have kind: " + (Object)((Object)typeElement.getKind())));
            }
        }
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return false;
        }
        if (Util.requiresEnclosingInstance(typeElement)) {
            return false;
        }
        for (Element element : typeElement.getEnclosedElements()) {
            if (!element.getKind().equals((Object)ElementKind.CONSTRUCTOR) || !((ExecutableElement)element).getParameters().isEmpty() || element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            return true;
        }
        return false;
    }

    private static ImmutableList<ExecutableElement> findLocalAndInheritedMethods(Elements elements, TypeElement type) {
        ArrayList methods = Lists.newArrayList();
        TypeElement objectType = elements.getTypeElement(Object.class.getName());
        Util.findLocalAndInheritedMethodsRecursive(objectType, elements, type, methods);
        return ImmutableList.copyOf((Collection)methods);
    }

    private static void findLocalAndInheritedMethodsRecursive(TypeElement objectType, Elements elements, TypeElement type, List<ExecutableElement> methods) {
        if (objectType.equals(type)) {
            return;
        }
        for (TypeMirror typeMirror : type.getInterfaces()) {
            Util.findLocalAndInheritedMethodsRecursive(objectType, elements, MoreElements.asType(MoreTypes.asElement(typeMirror)), methods);
        }
        if (type.getSuperclass().getKind() != TypeKind.NONE) {
            Util.findLocalAndInheritedMethodsRecursive(objectType, elements, MoreElements.asType(MoreTypes.asElement(type.getSuperclass())), methods);
        }
        List<ExecutableElement> theseMethods = ElementFilter.methodsIn(type.getEnclosedElements());
        for (ExecutableElement method : theseMethods) {
            if (method.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            boolean alreadySeen = false;
            Iterator<ExecutableElement> methodIter = methods.iterator();
            while (methodIter.hasNext()) {
                ExecutableElement otherMethod = methodIter.next();
                if (elements.overrides(method, otherMethod, type)) {
                    methodIter.remove();
                    continue;
                }
                if (!method.getSimpleName().equals(otherMethod.getSimpleName()) || !method.getParameters().equals(otherMethod.getParameters())) continue;
                alreadySeen = true;
            }
            if (alreadySeen) continue;
            methods.add(method);
        }
    }

    static ImmutableSet<ExecutableElement> getUnimplementedMethods(Elements elements, TypeElement type) {
        ImmutableSet.Builder unimplementedMethods = ImmutableSet.builder();
        ImmutableList<ExecutableElement> methods = Util.findLocalAndInheritedMethods(elements, type);
        for (ExecutableElement method : methods) {
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            unimplementedMethods.add((Object)method);
        }
        return unimplementedMethods.build();
    }

    private Util() {
    }
}

