/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.AutoValue_ValidationReport;
import dagger.internal.codegen.AutoValue_ValidationReport_Item;
import dagger.internal.codegen.PrintableErrorMessage;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

abstract class ValidationReport<T> {
    ValidationReport() {
    }

    abstract T subject();

    abstract ImmutableSet<Item> items();

    boolean isClean() {
        for (Item item : this.items()) {
            switch (item.kind()) {
                case ERROR: {
                    return false;
                }
            }
        }
        return true;
    }

    void printMessagesTo(Messager messager) {
        for (Item item : this.items()) {
            item.printMessageTo(messager);
        }
    }

    static final class Builder<T> {
        private final T subject;
        private final ImmutableSet.Builder<Item> items = ImmutableSet.builder();

        static <T> Builder<T> about(T subject) {
            return new Builder<T>(subject);
        }

        private Builder(T subject) {
            this.subject = subject;
        }

        T getSubject() {
            return this.subject;
        }

        Builder<T> addItems(Iterable<Item> newItems) {
            this.items.addAll(newItems);
            return this;
        }

        Builder<T> addItem(String message, Element element) {
            this.addItem(message, Diagnostic.Kind.ERROR, element, (Optional<AnnotationMirror>)Optional.absent());
            return this;
        }

        Builder<T> addItem(String message, Diagnostic.Kind kind, Element element) {
            this.addItem(message, kind, element, (Optional<AnnotationMirror>)Optional.absent());
            return this;
        }

        Builder<T> addItem(String message, Element element, AnnotationMirror annotation) {
            this.addItem(message, Diagnostic.Kind.ERROR, element, (Optional<AnnotationMirror>)Optional.of((Object)annotation));
            return this;
        }

        Builder<T> addItem(String message, Diagnostic.Kind kind, Element element, AnnotationMirror annotation) {
            this.addItem(message, kind, element, (Optional<AnnotationMirror>)Optional.of((Object)annotation));
            return this;
        }

        private Builder<T> addItem(String message, Diagnostic.Kind kind, Element element, Optional<AnnotationMirror> annotation) {
            this.items.add((Object)new AutoValue_ValidationReport_Item(message, kind, element, annotation));
            return this;
        }

        ValidationReport<T> build() {
            return new AutoValue_ValidationReport<T>(this.subject, (ImmutableSet<Item>)this.items.build());
        }
    }

    static abstract class Item
    implements PrintableErrorMessage {
        Item() {
        }

        abstract String message();

        abstract Diagnostic.Kind kind();

        abstract Element element();

        abstract Optional<AnnotationMirror> annotation();

        @Override
        public void printMessageTo(Messager messager) {
            if (this.annotation().isPresent()) {
                messager.printMessage(this.kind(), this.message(), this.element(), (AnnotationMirror)this.annotation().get());
            } else {
                messager.printMessage(this.kind(), this.message(), this.element());
            }
        }
    }
}

