/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.HasClassReferences;
import dagger.internal.codegen.writer.StringLiteral;
import dagger.internal.codegen.writer.Writable;
import dagger.internal.codegen.writer.Writables;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public final class AnnotationWriter
implements Writable,
HasClassReferences {
    private final ClassName annotationName;
    private final SortedMap<String, Writable> memberMap = Maps.newTreeMap();

    AnnotationWriter(ClassName annotationName) {
        this.annotationName = annotationName;
    }

    public void setValue(String value) {
        this.setMember("value", value);
    }

    public void setMember(String name, int value) {
        this.memberMap.put(name, Writables.toStringWritable(value));
    }

    public void setMember(String name, String value) {
        this.memberMap.put(name, Writables.toStringWritable(StringLiteral.forValue(value)));
    }

    @Override
    public Appendable write(Appendable appendable, Writable.Context context) throws IOException {
        appendable.append('@');
        this.annotationName.write(appendable, context);
        if (!this.memberMap.isEmpty()) {
            appendable.append('(');
            if (this.memberMap.size() == 1) {
                Map.Entry onlyEntry = (Map.Entry)Iterables.getOnlyElement(this.memberMap.entrySet());
                if (!((String)onlyEntry.getKey()).equals("value")) {
                    appendable.append((CharSequence)onlyEntry.getKey()).append(" = ");
                }
                ((Writable)onlyEntry.getValue()).write(appendable, context);
            }
            appendable.append(')');
        }
        return appendable;
    }

    @Override
    public Set<ClassName> referencedClasses() {
        return ImmutableSet.of((Object)this.annotationName);
    }
}

