/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.HasClassReferences;
import dagger.internal.codegen.writer.Snippet;
import dagger.internal.codegen.writer.Writable;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public final class BlockWriter
implements Writable,
HasClassReferences {
    private final List<Snippet> snippets = Lists.newArrayList();

    BlockWriter() {
    }

    public BlockWriter addSnippet(String snippet, Object ... args) {
        this.snippets.add(Snippet.format(snippet, args));
        return this;
    }

    public BlockWriter addSnippet(Snippet snippet) {
        this.snippets.add(snippet);
        return this;
    }

    boolean isEmpty() {
        return this.snippets.isEmpty();
    }

    @Override
    public Appendable write(Appendable appendable, Writable.Context context) throws IOException {
        for (Snippet snippet : this.snippets) {
            appendable.append('\n');
            snippet.write(appendable, context);
        }
        return appendable.append('\n');
    }

    @Override
    public Set<ClassName> referencedClasses() {
        return FluentIterable.from(this.snippets).transformAndConcat((Function)new Function<HasClassReferences, Set<ClassName>>(){

            public Set<ClassName> apply(HasClassReferences input) {
                return input.referencedClasses();
            }
        }).toSet();
    }
}

