/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.ConstructorWriter;
import dagger.internal.codegen.writer.HasClassReferences;
import dagger.internal.codegen.writer.IndentingAppendable;
import dagger.internal.codegen.writer.MethodWriter;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.TypeVariableName;
import dagger.internal.codegen.writer.TypeWriter;
import dagger.internal.codegen.writer.VariableWriter;
import dagger.internal.codegen.writer.Writable;
import dagger.internal.codegen.writer.Writables;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public final class ClassWriter
extends TypeWriter {
    private Optional<TypeName> superclass = Optional.absent();
    private final List<ConstructorWriter> constructorWriters = Lists.newArrayList();
    private final List<TypeVariableName> typeParameters = Lists.newArrayList();
    private static final Set<Modifier> VISIBILIY_MODIFIERS = Sets.immutableEnumSet((Enum)Modifier.PUBLIC, (Enum[])new Modifier[]{Modifier.PROTECTED, Modifier.PRIVATE});

    ClassWriter(ClassName className) {
        super(className);
    }

    public void setSuperclass(TypeName typeReference) {
        Preconditions.checkState((!this.superclass.isPresent() ? 1 : 0) != 0);
        this.superclass = Optional.of((Object)typeReference);
    }

    public void setSupertype(TypeElement supertype) {
        switch (supertype.getKind()) {
            case CLASS: {
                this.setSuperclass(ClassName.fromTypeElement(supertype));
                break;
            }
            case INTERFACE: {
                this.addImplementedType(supertype);
                break;
            }
            default: {
                throw new IllegalArgumentException(supertype + " must be a class or interface");
            }
        }
    }

    public ConstructorWriter addConstructor() {
        ConstructorWriter constructorWriter = new ConstructorWriter(this.name.simpleName());
        this.constructorWriters.add(constructorWriter);
        return constructorWriter;
    }

    public void addTypeParameter(TypeVariableName typeVariableName) {
        this.typeParameters.add(typeVariableName);
    }

    public void addTypeParameters(Iterable<TypeVariableName> typeVariableNames) {
        Iterables.addAll(this.typeParameters, typeVariableNames);
    }

    public List<TypeVariableName> typeParameters() {
        return ImmutableList.copyOf(this.typeParameters);
    }

    @Override
    public Appendable write(Appendable appendable, Writable.Context context) throws IOException {
        context = context.createSubcontext((Set<ClassName>)FluentIterable.from((Iterable)this.nestedTypeWriters).transform((Function)new Function<TypeWriter, ClassName>(){

            public ClassName apply(TypeWriter input) {
                return input.name;
            }
        }).toSet());
        this.writeAnnotations(appendable, context);
        this.writeModifiers(appendable).append("class ").append(this.name.simpleName());
        Writables.join(", ", this.typeParameters, "<", ">", appendable, context);
        if (this.superclass.isPresent()) {
            appendable.append(" extends ");
            ((TypeName)this.superclass.get()).write(appendable, context);
        }
        Writables.join(", ", this.implementedTypes, " implements ", "", appendable, context);
        appendable.append(" {");
        if (!this.fieldWriters.isEmpty()) {
            appendable.append('\n');
        }
        for (VariableWriter fieldWriter : this.fieldWriters.values()) {
            fieldWriter.write(new IndentingAppendable(appendable), context).append("\n");
        }
        for (ConstructorWriter constructorWriter : this.constructorWriters) {
            appendable.append('\n');
            if (this.isDefaultConstructor(constructorWriter)) continue;
            constructorWriter.write(new IndentingAppendable(appendable), context);
        }
        for (MethodWriter methodWriter : this.methodWriters) {
            appendable.append('\n');
            methodWriter.write(new IndentingAppendable(appendable), context);
        }
        for (TypeWriter nestedTypeWriter : this.nestedTypeWriters) {
            appendable.append('\n');
            nestedTypeWriter.write(new IndentingAppendable(appendable), context);
        }
        appendable.append("}\n");
        return appendable;
    }

    private boolean isDefaultConstructor(ConstructorWriter constructorWriter) {
        return Sets.intersection(VISIBILIY_MODIFIERS, (Set)this.modifiers).equals((Object)Sets.intersection(VISIBILIY_MODIFIERS, (Set)constructorWriter.modifiers)) && constructorWriter.body().isEmpty();
    }

    @Override
    public Set<ClassName> referencedClasses() {
        Iterable concat = Iterables.concat((Iterable[])new Iterable[]{this.nestedTypeWriters, this.fieldWriters.values(), this.constructorWriters, this.methodWriters, this.implementedTypes, this.superclass.asSet(), this.annotations, this.typeParameters});
        return FluentIterable.from((Iterable)concat).transformAndConcat((Function)new Function<HasClassReferences, Set<ClassName>>(){

            public Set<ClassName> apply(HasClassReferences input) {
                return input.referencedClasses();
            }
        }).toSet();
    }
}

