/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.ConstructorWriter;
import dagger.internal.codegen.writer.HasClassReferences;
import dagger.internal.codegen.writer.IndentingAppendable;
import dagger.internal.codegen.writer.MethodWriter;
import dagger.internal.codegen.writer.Snippet;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.TypeWriter;
import dagger.internal.codegen.writer.VariableWriter;
import dagger.internal.codegen.writer.Writable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;

public final class EnumWriter
extends TypeWriter {
    private final Map<String, ConstantWriter> constantWriters = Maps.newLinkedHashMap();
    private final List<ConstructorWriter> constructorWriters = Lists.newArrayList();
    private static final Set<Modifier> VISIBILIY_MODIFIERS = Sets.immutableEnumSet((Enum)Modifier.PUBLIC, (Enum[])new Modifier[]{Modifier.PROTECTED, Modifier.PRIVATE});

    EnumWriter(ClassName name) {
        super(name);
    }

    public ConstantWriter addConstant(String name) {
        ConstantWriter constantWriter = new ConstantWriter(name);
        this.constantWriters.put(name, constantWriter);
        return constantWriter;
    }

    public ConstructorWriter addConstructor() {
        ConstructorWriter constructorWriter = new ConstructorWriter(this.name.simpleName());
        this.constructorWriters.add(constructorWriter);
        return constructorWriter;
    }

    @Override
    public Appendable write(Appendable appendable, Writable.Context context) throws IOException {
        context = context.createSubcontext((Set<ClassName>)FluentIterable.from((Iterable)this.nestedTypeWriters).transform((Function)new Function<TypeWriter, ClassName>(){

            public ClassName apply(TypeWriter input) {
                return input.name;
            }
        }).toSet());
        this.writeAnnotations(appendable, context);
        this.writeModifiers(appendable).append("enum ").append(this.name.simpleName());
        Iterator implementedTypesIterator = this.implementedTypes.iterator();
        if (implementedTypesIterator.hasNext()) {
            appendable.append(" implements ");
            ((TypeName)implementedTypesIterator.next()).write(appendable, context);
            while (implementedTypesIterator.hasNext()) {
                appendable.append(", ");
                ((TypeName)implementedTypesIterator.next()).write(appendable, context);
            }
        }
        appendable.append(" {");
        Preconditions.checkState((!this.constantWriters.isEmpty() ? 1 : 0) != 0, (Object)"Cannot write an enum with no constants.");
        appendable.append('\n');
        ImmutableList constantWriterList = ImmutableList.copyOf(this.constantWriters.values());
        for (ConstantWriter constantWriter : constantWriterList.subList(0, constantWriterList.size() - 1)) {
            constantWriter.write(appendable, context);
            appendable.append(",\n");
        }
        ((ConstantWriter)constantWriterList.get(constantWriterList.size() - 1)).write(appendable, context);
        appendable.append(";\n");
        if (!this.fieldWriters.isEmpty()) {
            appendable.append('\n');
        }
        for (VariableWriter fieldWriter : this.fieldWriters.values()) {
            fieldWriter.write(new IndentingAppendable(appendable), context).append("\n");
        }
        for (ConstructorWriter constructorWriter : this.constructorWriters) {
            appendable.append('\n');
            if (this.isDefaultConstructor(constructorWriter)) continue;
            constructorWriter.write(new IndentingAppendable(appendable), context);
        }
        for (MethodWriter methodWriter : this.methodWriters) {
            appendable.append('\n');
            methodWriter.write(new IndentingAppendable(appendable), context);
        }
        for (TypeWriter nestedTypeWriter : this.nestedTypeWriters) {
            appendable.append('\n');
            nestedTypeWriter.write(new IndentingAppendable(appendable), context);
        }
        appendable.append("}\n");
        return appendable;
    }

    private boolean isDefaultConstructor(ConstructorWriter constructorWriter) {
        return Sets.intersection(VISIBILIY_MODIFIERS, (Set)this.modifiers).equals((Object)Sets.intersection(VISIBILIY_MODIFIERS, (Set)constructorWriter.modifiers)) && constructorWriter.body().isEmpty();
    }

    @Override
    public Set<ClassName> referencedClasses() {
        Iterable concat = Iterables.concat((Iterable[])new Iterable[]{this.nestedTypeWriters, this.constantWriters.values(), this.fieldWriters.values(), this.constructorWriters, this.methodWriters, this.implementedTypes, this.annotations});
        return FluentIterable.from((Iterable)concat).transformAndConcat((Function)new Function<HasClassReferences, Set<ClassName>>(){

            public Set<ClassName> apply(HasClassReferences input) {
                return input.referencedClasses();
            }
        }).toSet();
    }

    public static final class ConstantWriter
    implements Writable,
    HasClassReferences {
        private final String name;
        private final List<Snippet> constructorSnippets;

        private ConstantWriter(String name) {
            this.name = name;
            this.constructorSnippets = Lists.newArrayList();
        }

        ConstantWriter addArgument(Snippet snippet) {
            this.constructorSnippets.add(snippet);
            return this;
        }

        @Override
        public Appendable write(Appendable appendable, Writable.Context context) throws IOException {
            appendable.append(this.name);
            Iterator<Snippet> snippetIterator = this.constructorSnippets.iterator();
            if (snippetIterator.hasNext()) {
                appendable.append('(');
                snippetIterator.next().write(appendable, context);
                while (snippetIterator.hasNext()) {
                    appendable.append(", ");
                    snippetIterator.next().write(appendable, context);
                }
                appendable.append(')');
            }
            return appendable;
        }

        @Override
        public Set<ClassName> referencedClasses() {
            return FluentIterable.from(this.constructorSnippets).transformAndConcat((Function)new Function<Snippet, Set<ClassName>>(){

                public Set<ClassName> apply(Snippet input) {
                    return input.referencedClasses();
                }
            }).toSet();
        }
    }
}

