/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.HasClassReferences;
import dagger.internal.codegen.writer.Snippet;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.VariableWriter;
import dagger.internal.codegen.writer.Writable;
import java.io.IOException;
import java.util.Set;

public final class FieldWriter
extends VariableWriter {
    private Optional<Snippet> initializer = Optional.absent();

    FieldWriter(TypeName type, String name) {
        super(type, name);
    }

    public void setInitializer(Snippet initializer) {
        this.initializer = Optional.of((Object)initializer);
    }

    public void setInitializer(String initializer, Object ... args) {
        this.initializer = Optional.of((Object)Snippet.format(initializer, args));
    }

    @Override
    public Appendable write(Appendable appendable, Writable.Context context) throws IOException {
        super.write(appendable, context);
        if (this.initializer.isPresent()) {
            appendable.append(" = ");
            ((Snippet)this.initializer.get()).write(appendable, context);
        }
        appendable.append(';');
        return appendable;
    }

    @Override
    public Set<ClassName> referencedClasses() {
        Iterable concat = Iterables.concat((Iterable)ImmutableList.of((Object)this.type()), (Iterable)this.initializer.asSet(), (Iterable)this.annotations);
        return FluentIterable.from((Iterable)concat).transformAndConcat((Function)new Function<HasClassReferences, Set<ClassName>>(){

            public Set<ClassName> apply(HasClassReferences input) {
                return input.referencedClasses();
            }
        }).toSet();
    }
}

