/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dagger.internal.codegen.writer.BlockWriter;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.HasClassReferences;
import dagger.internal.codegen.writer.IndentingAppendable;
import dagger.internal.codegen.writer.Modifiable;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.TypeVariableName;
import dagger.internal.codegen.writer.TypeWriter;
import dagger.internal.codegen.writer.VariableWriter;
import dagger.internal.codegen.writer.Writable;
import dagger.internal.codegen.writer.Writables;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;

public final class MethodWriter
extends Modifiable
implements HasClassReferences,
Writable {
    private final TypeName returnType;
    private final String name;
    private final Map<String, VariableWriter> parameterWriters;
    private final List<TypeVariableName> typeParameters;
    private Optional<BlockWriter> body;

    MethodWriter(TypeName returnType, String name) {
        this.returnType = returnType;
        this.name = name;
        this.parameterWriters = Maps.newLinkedHashMap();
        this.typeParameters = Lists.newArrayList();
        this.body = Optional.absent();
    }

    public String name() {
        return this.name;
    }

    public TypeName returnType() {
        return this.returnType;
    }

    public void addTypeParameter(TypeVariableName typeVariableName) {
        this.typeParameters.add(typeVariableName);
    }

    public void addTypeParameters(Iterable<TypeVariableName> typeVariableNames) {
        Iterables.addAll(this.typeParameters, typeVariableNames);
    }

    public VariableWriter addParameter(Class<?> type, String name) {
        return this.addParameter(ClassName.fromClass(type), name);
    }

    public VariableWriter addParameter(TypeElement type, String name) {
        return this.addParameter(ClassName.fromTypeElement(type), name);
    }

    public VariableWriter addParameter(TypeWriter type, String name) {
        return this.addParameter(type.name, name);
    }

    public VariableWriter addParameter(TypeName type, String name) {
        Preconditions.checkArgument((!this.parameterWriters.containsKey(name) ? 1 : 0) != 0);
        VariableWriter parameterWriter = new VariableWriter(type, name);
        this.parameterWriters.put(name, parameterWriter);
        return parameterWriter;
    }

    public BlockWriter body() {
        if (this.body.isPresent()) {
            return (BlockWriter)this.body.get();
        }
        BlockWriter blockWriter = new BlockWriter();
        this.body = Optional.of((Object)blockWriter);
        return blockWriter;
    }

    @Override
    public Appendable write(Appendable appendable, Writable.Context context) throws IOException {
        this.writeAnnotations(appendable, context);
        this.writeModifiers(appendable);
        Writables.join(", ", this.typeParameters, "<", "> ", appendable, context);
        this.returnType.write(appendable, context);
        appendable.append(' ').append(this.name).append('(');
        Writables.join(", ", this.parameterWriters.values(), appendable, context);
        appendable.append(")");
        if (this.body.isPresent()) {
            appendable.append(" {");
            ((BlockWriter)this.body.get()).write(new IndentingAppendable(appendable), context);
            appendable.append("}\n");
        } else {
            appendable.append(";\n");
        }
        return appendable;
    }

    @Override
    public Set<ClassName> referencedClasses() {
        return FluentIterable.from((Iterable)Iterables.concat((Iterable)ImmutableList.of((Object)this.returnType), this.parameterWriters.values(), (Iterable)this.body.asSet())).transformAndConcat((Function)new Function<HasClassReferences, Set<ClassName>>(){

            public Set<ClassName> apply(HasClassReferences input) {
                return input.referencedClasses();
            }
        }).toSet();
    }
}

