/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import dagger.internal.codegen.writer.AnnotationWriter;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.Writable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;

public abstract class Modifiable {
    final Set<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
    final List<AnnotationWriter> annotations = Lists.newArrayList();

    Modifiable() {
    }

    public void addModifiers(Modifier first, Modifier ... rest) {
        this.addModifiers(Lists.asList((Object)((Object)first), (Object[])rest));
    }

    public void addModifiers(Iterable<Modifier> modifiers) {
        Iterables.addAll(this.modifiers, modifiers);
    }

    public AnnotationWriter annotate(ClassName annotation) {
        AnnotationWriter annotationWriter = new AnnotationWriter(annotation);
        this.annotations.add(annotationWriter);
        return annotationWriter;
    }

    public AnnotationWriter annotate(Class<? extends Annotation> annotation) {
        return this.annotate(ClassName.fromClass(annotation));
    }

    Appendable writeModifiers(Appendable appendable) throws IOException {
        for (Modifier modifier : this.modifiers) {
            appendable.append(modifier.toString()).append(' ');
        }
        return appendable;
    }

    Appendable writeAnnotations(Appendable appendable, Writable.Context context) throws IOException {
        for (AnnotationWriter annotationWriter : this.annotations) {
            annotationWriter.write(appendable, context).append('\n');
        }
        return appendable;
    }
}

