/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.Writable;
import java.io.IOException;
import java.util.Set;
import javax.lang.model.type.PrimitiveType;

public enum PrimitiveName implements TypeName
{
    BOOLEAN,
    BYTE,
    SHORT,
    INT,
    LONG,
    CHAR,
    FLOAT,
    DOUBLE;


    @Override
    public Set<ClassName> referencedClasses() {
        return ImmutableSet.of();
    }

    public String toString() {
        return Ascii.toLowerCase((String)this.name());
    }

    @Override
    public Appendable write(Appendable appendable, Writable.Context context) throws IOException {
        return appendable.append(this.toString());
    }

    static PrimitiveName forTypeMirror(PrimitiveType mirror) {
        switch (mirror.getKind()) {
            case BOOLEAN: {
                return BOOLEAN;
            }
            case BYTE: {
                return BYTE;
            }
            case SHORT: {
                return SHORT;
            }
            case INT: {
                return INT;
            }
            case LONG: {
                return LONG;
            }
            case CHAR: {
                return CHAR;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
        }
        throw new AssertionError();
    }

    static PrimitiveName forClass(Class<?> primitiveClass) {
        if (Boolean.TYPE.equals(primitiveClass)) {
            return BOOLEAN;
        }
        if (Byte.TYPE.equals(primitiveClass)) {
            return BYTE;
        }
        if (Short.TYPE.equals(primitiveClass)) {
            return SHORT;
        }
        if (Integer.TYPE.equals(primitiveClass)) {
            return INT;
        }
        if (Long.TYPE.equals(primitiveClass)) {
            return LONG;
        }
        if (Character.TYPE.equals(primitiveClass)) {
            return CHAR;
        }
        if (Float.TYPE.equals(primitiveClass)) {
            return FLOAT;
        }
        if (Double.TYPE.equals(primitiveClass)) {
            return DOUBLE;
        }
        throw new IllegalArgumentException(primitiveClass + " is not a primitive type");
    }
}

