/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import dagger.internal.codegen.writer.ArrayTypeName;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.NullName;
import dagger.internal.codegen.writer.ParameterizedTypeName;
import dagger.internal.codegen.writer.PrimitiveName;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.TypeVariableName;
import dagger.internal.codegen.writer.VoidName;
import dagger.internal.codegen.writer.WildcardName;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;

public final class TypeNames {
    static final Function<TypeMirror, TypeName> FOR_TYPE_MIRROR = new Function<TypeMirror, TypeName>(){

        public TypeName apply(TypeMirror input) {
            return TypeNames.forTypeMirror(input);
        }
    };

    public static TypeName forClass(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return PrimitiveName.forClass(clazz);
        }
        if (Void.TYPE.equals(clazz)) {
            return VoidName.VOID;
        }
        if (clazz.isArray()) {
            return new ArrayTypeName(TypeNames.forClass(clazz.getComponentType()));
        }
        return ClassName.fromClass(clazz);
    }

    public static TypeName forTypeMirror(TypeMirror mirror) {
        return mirror.accept(new SimpleTypeVisitor6<TypeName, Void>(){

            @Override
            protected TypeName defaultAction(TypeMirror e, Void p) {
                throw new IllegalArgumentException(e.toString());
            }

            @Override
            public TypeName visitTypeVariable(TypeVariable t, Void p) {
                return TypeVariableName.fromTypeVariable(t);
            }

            @Override
            public ArrayTypeName visitArray(ArrayType t, Void p) {
                return new ArrayTypeName(t.getComponentType().accept(this, null));
            }

            @Override
            public TypeName visitDeclared(DeclaredType t, Void p) {
                return t.getTypeArguments().isEmpty() ? ClassName.fromTypeElement((TypeElement)t.asElement()) : new ParameterizedTypeName(ClassName.fromTypeElement((TypeElement)t.asElement()), (Iterable<? extends TypeName>)FluentIterable.from(t.getTypeArguments()).transform(FOR_TYPE_MIRROR));
            }

            @Override
            public PrimitiveName visitPrimitive(PrimitiveType t, Void p) {
                return PrimitiveName.forTypeMirror(t);
            }

            @Override
            public WildcardName visitWildcard(WildcardType t, Void p) {
                return WildcardName.forTypeMirror(t);
            }

            @Override
            public NullName visitNull(NullType t, Void p) {
                return NullName.NULL;
            }

            @Override
            public TypeName visitNoType(NoType t, Void p) {
                switch (t.getKind()) {
                    case VOID: {
                        return VoidName.VOID;
                    }
                    case PACKAGE: {
                        throw new IllegalArgumentException();
                    }
                }
                throw new IllegalStateException();
            }
        }, null);
    }

    private TypeNames() {
    }
}

