/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.TypeNames;
import dagger.internal.codegen.writer.Writable;
import java.io.IOException;
import java.util.Set;
import javax.lang.model.type.WildcardType;

public final class WildcardName
implements TypeName {
    private final Optional<TypeName> extendsBound;
    private final Optional<TypeName> superBound;

    WildcardName(Optional<TypeName> extendsBound, Optional<TypeName> superBound) {
        this.extendsBound = extendsBound;
        this.superBound = superBound;
    }

    static WildcardName forTypeMirror(WildcardType mirror) {
        return new WildcardName((Optional<TypeName>)Optional.fromNullable((Object)mirror.getExtendsBound()).transform(TypeNames.FOR_TYPE_MIRROR), (Optional<TypeName>)Optional.fromNullable((Object)mirror.getSuperBound()).transform(TypeNames.FOR_TYPE_MIRROR));
    }

    @Override
    public Set<ClassName> referencedClasses() {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        if (this.extendsBound.isPresent()) {
            builder.addAll(((TypeName)this.extendsBound.get()).referencedClasses());
        }
        if (this.superBound.isPresent()) {
            builder.addAll(((TypeName)this.superBound.get()).referencedClasses());
        }
        return builder.build();
    }

    @Override
    public Appendable write(Appendable appendable, Writable.Context context) throws IOException {
        appendable.append('?');
        if (this.extendsBound.isPresent()) {
            appendable.append(" extends ");
            ((TypeName)this.extendsBound.get()).write(appendable, context);
        }
        if (this.superBound.isPresent()) {
            appendable.append(" super ");
            ((TypeName)this.superBound.get()).write(appendable, context);
        }
        return appendable;
    }
}

