/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.producers.Producer;
import dagger.producers.internal.CancellableProducer;
import dagger.producers.internal.CancellationListener;

public final class Producers {
    public static <T> Producer<T> immediateProducer(T value) {
        return new ImmediateProducer(Futures.immediateFuture(value));
    }

    public static <T> Producer<T> immediateFailedProducer(Throwable throwable) {
        return new ImmediateProducer(Futures.immediateFailedFuture((Throwable)throwable));
    }

    private Producers() {
    }

    private static final class ImmediateProducer<T>
    implements CancellableProducer<T> {
        private final ListenableFuture<T> future;

        ImmediateProducer(ListenableFuture<T> future) {
            this.future = future;
        }

        @Override
        public ListenableFuture<T> get() {
            return this.future;
        }

        @Override
        public void cancel(boolean mayInterruptIfRunning) {
        }

        @Override
        public Producer<T> newDependencyView() {
            return this;
        }

        @Override
        public Producer<T> newEntryPointView(CancellationListener cancellationListener) {
            return this;
        }
    }
}

