/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.inappmessaging.CommonTypesProto;
import com.google.firebase.inappmessaging.internal.FiamAnalyticsConnectorListener;
import com.google.firebase.inappmessaging.internal.Logging;
import com.google.internal.firebase.inappmessaging.v1.CampaignProto;
import com.google.internal.firebase.inappmessaging.v1.sdkserving.FetchEligibleCampaignsResponse;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.flowables.ConnectableFlowable;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class AnalyticsEventsManager {
    private final AnalyticsConnector analyticsConnector;
    private final ConnectableFlowable<String> flowable;
    private AnalyticsConnector.AnalyticsConnectorHandle handle;
    @VisibleForTesting
    static final String TOO_MANY_CONTEXTUAL_TRIGGERS_ERROR = "Too many contextual triggers defined - limiting to 50";

    public AnalyticsEventsManager(AnalyticsConnector analyticsConnector) {
        this.analyticsConnector = analyticsConnector;
        AnalyticsFlowableSubscriber subscriber = new AnalyticsFlowableSubscriber();
        this.flowable = Flowable.create((FlowableOnSubscribe)subscriber, (BackpressureStrategy)BackpressureStrategy.BUFFER).publish();
        this.flowable.connect();
    }

    @Nullable
    public AnalyticsConnector.AnalyticsConnectorHandle getHandle() {
        return this.handle;
    }

    public ConnectableFlowable<String> getAnalyticsEventsFlowable() {
        return this.flowable;
    }

    @VisibleForTesting
    static Set<String> extractAnalyticsEventNames(FetchEligibleCampaignsResponse response) {
        HashSet<String> analyticsEvents = new HashSet<String>();
        for (CampaignProto.ThickContent content : response.getMessagesList()) {
            for (CommonTypesProto.TriggeringCondition condition : content.getTriggeringConditionsList()) {
                if (TextUtils.isEmpty((CharSequence)condition.getEvent().getName())) continue;
                analyticsEvents.add(condition.getEvent().getName());
            }
        }
        if (analyticsEvents.size() > 50) {
            Logging.logi(TOO_MANY_CONTEXTUAL_TRIGGERS_ERROR);
        }
        return analyticsEvents;
    }

    public void updateContextualTriggers(FetchEligibleCampaignsResponse serviceResponse) {
        Set<String> analyticsEventNames = AnalyticsEventsManager.extractAnalyticsEventNames(serviceResponse);
        Logging.logd("Updating contextual triggers for the following analytics events: " + analyticsEventNames);
        this.handle.registerEventNames(analyticsEventNames);
    }

    private class AnalyticsFlowableSubscriber
    implements FlowableOnSubscribe<String> {
        AnalyticsFlowableSubscriber() {
        }

        @SuppressLint(value={"InvalidDeferredApiUse"})
        public void subscribe(FlowableEmitter<String> emitter) {
            Logging.logd("Subscribing to analytics events.");
            AnalyticsEventsManager.this.handle = AnalyticsEventsManager.this.analyticsConnector.registerAnalyticsConnectorListener("fiam", (AnalyticsConnector.AnalyticsConnectorListener)new FiamAnalyticsConnectorListener(emitter));
        }
    }
}

