/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal;

import android.os.Bundle;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.inject.Deferred;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProxyAnalyticsConnector
implements AnalyticsConnector {
    private volatile Object instance;

    public ProxyAnalyticsConnector(Deferred<AnalyticsConnector> analyticsConnector) {
        this.instance = analyticsConnector;
        analyticsConnector.whenAvailable(connectorProvider -> {
            this.instance = connectorProvider.get();
        });
    }

    private AnalyticsConnector safeGet() {
        Object result = this.instance;
        if (result instanceof AnalyticsConnector) {
            return (AnalyticsConnector)result;
        }
        return null;
    }

    public void logEvent(@NonNull String s, @NonNull String s1, @NonNull Bundle bundle) {
        AnalyticsConnector connector = this.safeGet();
        if (connector != null) {
            connector.logEvent(s, s1, bundle);
        }
    }

    public void setUserProperty(@NonNull String s, @NonNull String s1, @NonNull Object o) {
        AnalyticsConnector connector = this.safeGet();
        if (connector != null) {
            connector.setUserProperty(s, s1, o);
        }
    }

    @NonNull
    public Map<String, Object> getUserProperties(boolean b) {
        return Collections.emptyMap();
    }

    @NonNull
    public AnalyticsConnector.AnalyticsConnectorHandle registerAnalyticsConnectorListener(@NonNull String s, @NonNull AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener) {
        Object result = this.instance;
        if (result instanceof AnalyticsConnector) {
            return ((AnalyticsConnector)result).registerAnalyticsConnectorListener(s, analyticsConnectorListener);
        }
        Deferred deferred = (Deferred)result;
        return new ProxyAnalyticsConnectorHandle(s, analyticsConnectorListener, deferred);
    }

    public void setConditionalUserProperty(@NonNull AnalyticsConnector.ConditionalUserProperty conditionalUserProperty) {
    }

    public void clearConditionalUserProperty(@NonNull String s, @Nullable String s1, @Nullable Bundle bundle) {
    }

    @NonNull
    public List<AnalyticsConnector.ConditionalUserProperty> getConditionalUserProperties(@NonNull String s, @Nullable String s1) {
        return Collections.emptyList();
    }

    public int getMaxUserProperties(@NonNull String s) {
        return 0;
    }

    private static class ProxyAnalyticsConnectorHandle
    implements AnalyticsConnector.AnalyticsConnectorHandle {
        private static final Object UNREGISTERED = new Object();
        @GuardedBy(value="this")
        private Set<String> eventNames = new HashSet<String>();
        private volatile Object instance;

        private ProxyAnalyticsConnectorHandle(String s, AnalyticsConnector.AnalyticsConnectorListener listener, Deferred<AnalyticsConnector> analyticsConnector) {
            analyticsConnector.whenAvailable(connectorProvider -> {
                Object result = this.instance;
                if (result == UNREGISTERED) {
                    return;
                }
                AnalyticsConnector connector = (AnalyticsConnector)connectorProvider.get();
                AnalyticsConnector.AnalyticsConnectorHandle handle = connector.registerAnalyticsConnectorListener(s, listener);
                this.instance = handle;
                ProxyAnalyticsConnectorHandle proxyAnalyticsConnectorHandle = this;
                synchronized (proxyAnalyticsConnectorHandle) {
                    if (!this.eventNames.isEmpty()) {
                        handle.registerEventNames(this.eventNames);
                        this.eventNames = new HashSet<String>();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            Object result = this.instance;
            if (result == UNREGISTERED) {
                return;
            }
            if (result != null) {
                AnalyticsConnector.AnalyticsConnectorHandle handle = (AnalyticsConnector.AnalyticsConnectorHandle)result;
                handle.unregister();
            }
            this.instance = UNREGISTERED;
            ProxyAnalyticsConnectorHandle proxyAnalyticsConnectorHandle = this;
            synchronized (proxyAnalyticsConnectorHandle) {
                this.eventNames.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerEventNames(@NonNull Set<String> set) {
            Object result = this.instance;
            if (result == UNREGISTERED) {
                return;
            }
            if (result != null) {
                AnalyticsConnector.AnalyticsConnectorHandle handle = (AnalyticsConnector.AnalyticsConnectorHandle)result;
                handle.registerEventNames(set);
                return;
            }
            ProxyAnalyticsConnectorHandle proxyAnalyticsConnectorHandle = this;
            synchronized (proxyAnalyticsConnectorHandle) {
                this.eventNames.addAll(set);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterEventNames() {
            Object result = this.instance;
            if (result == UNREGISTERED) {
                return;
            }
            if (result != null) {
                AnalyticsConnector.AnalyticsConnectorHandle handle = (AnalyticsConnector.AnalyticsConnectorHandle)result;
                handle.unregisterEventNames();
                return;
            }
            ProxyAnalyticsConnectorHandle proxyAnalyticsConnectorHandle = this;
            synchronized (proxyAnalyticsConnectorHandle) {
                this.eventNames.clear();
            }
        }
    }
}

