/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.model;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.firebase.inappmessaging.model.Action;
import com.google.firebase.inappmessaging.model.CampaignMetadata;
import com.google.firebase.inappmessaging.model.ImageData;
import com.google.firebase.inappmessaging.model.InAppMessage;
import com.google.firebase.inappmessaging.model.MessageType;
import com.google.firebase.inappmessaging.model.Text;
import java.util.Map;
import javax.annotation.Nullable;

public class BannerMessage
extends InAppMessage {
    @NonNull
    private final Text title;
    @Nullable
    private final Text body;
    @Nullable
    private final ImageData imageData;
    @Nullable
    private final Action action;
    @NonNull
    private final String backgroundHexColor;

    public int hashCode() {
        int bodyHash = this.body != null ? this.body.hashCode() : 0;
        int imageHash = this.imageData != null ? this.imageData.hashCode() : 0;
        int actionHash = this.action != null ? this.action.hashCode() : 0;
        return this.title.hashCode() + bodyHash + imageHash + actionHash + this.backgroundHexColor.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BannerMessage)) {
            return false;
        }
        BannerMessage b = (BannerMessage)o;
        if (this.hashCode() != b.hashCode()) {
            return false;
        }
        if (this.body == null && b.body != null || this.body != null && !this.body.equals(b.body)) {
            return false;
        }
        if (this.imageData == null && b.imageData != null || this.imageData != null && !this.imageData.equals(b.imageData)) {
            return false;
        }
        if (this.action == null && b.action != null || this.action != null && !this.action.equals(b.action)) {
            return false;
        }
        if (!this.title.equals(b.title)) {
            return false;
        }
        return this.backgroundHexColor.equals(b.backgroundHexColor);
    }

    private BannerMessage(@NonNull CampaignMetadata campaignMetadata, @NonNull Text title, @Nullable Text body, @Nullable ImageData imageData, @Nullable Action action, @NonNull String backgroundHexColor, @Nullable Map<String, String> data) {
        super(campaignMetadata, MessageType.BANNER, data);
        this.title = title;
        this.body = body;
        this.imageData = imageData;
        this.action = action;
        this.backgroundHexColor = backgroundHexColor;
    }

    @Override
    @NonNull
    public Text getTitle() {
        return this.title;
    }

    @Override
    @Nullable
    public Text getBody() {
        return this.body;
    }

    @Override
    @Nullable
    public ImageData getImageData() {
        return this.imageData;
    }

    @Override
    @Nullable
    public Action getAction() {
        return this.action;
    }

    @Override
    @NonNull
    public String getBackgroundHexColor() {
        return this.backgroundHexColor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        Text title;
        @Nullable
        Text body;
        @Nullable
        ImageData imageData;
        @Nullable
        Action action;
        @Nullable
        String backgroundHexColor;

        public Builder setTitle(@Nullable Text title) {
            this.title = title;
            return this;
        }

        public Builder setBody(@Nullable Text body) {
            this.body = body;
            return this;
        }

        public Builder setImageData(@Nullable ImageData imageData) {
            this.imageData = imageData;
            return this;
        }

        public Builder setAction(@Nullable Action action) {
            this.action = action;
            return this;
        }

        public Builder setBackgroundHexColor(@Nullable String backgroundHexColor) {
            this.backgroundHexColor = backgroundHexColor;
            return this;
        }

        public BannerMessage build(CampaignMetadata campaignMetadata, @Nullable Map<String, String> data) {
            if (this.title == null) {
                throw new IllegalArgumentException("Banner model must have a title");
            }
            if (TextUtils.isEmpty((CharSequence)this.backgroundHexColor)) {
                throw new IllegalArgumentException("Banner model must have a background color");
            }
            return new BannerMessage(campaignMetadata, this.title, this.body, this.imageData, this.action, this.backgroundHexColor, data);
        }
    }
}

