/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.model;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.inappmessaging.MessagesProto;
import com.google.firebase.inappmessaging.model.Text;

public class Button {
    @NonNull
    private final Text text;
    @NonNull
    private final String buttonHexColor;

    public int hashCode() {
        return this.text.hashCode() + this.buttonHexColor.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Button)) {
            return false;
        }
        Button b = (Button)o;
        if (this.hashCode() != b.hashCode()) {
            return false;
        }
        if (!this.text.equals(b.text)) {
            return false;
        }
        return this.buttonHexColor.equals(b.buttonHexColor);
    }

    private Button(@NonNull Text text, @NonNull String buttonHexColor) {
        this.text = text;
        this.buttonHexColor = buttonHexColor;
    }

    @NonNull
    public Text getText() {
        return this.text;
    }

    @NonNull
    public String getButtonHexColor() {
        return this.buttonHexColor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private Text text;
        @Nullable
        private String buttonHexColor;

        public Builder setText(@Nullable Text text) {
            this.text = text;
            return this;
        }

        public Builder setText(MessagesProto.Text text) {
            Text.Builder textBuilder = new Text.Builder();
            textBuilder.setText(text);
            this.text = textBuilder.build();
            return this;
        }

        public Builder setButtonHexColor(@Nullable String buttonHexColor) {
            this.buttonHexColor = buttonHexColor;
            return this;
        }

        public Button build() {
            if (TextUtils.isEmpty((CharSequence)this.buttonHexColor)) {
                throw new IllegalArgumentException("Button model must have a color");
            }
            if (this.text == null) {
                throw new IllegalArgumentException("Button model must have text");
            }
            return new Button(this.text, this.buttonHexColor);
        }
    }
}

