/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.model;

import android.graphics.Bitmap;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class ImageData {
    @NonNull
    private final String imageUrl;
    @Nullable
    private final Bitmap bitmapData;

    public int hashCode() {
        int bitmapHash = this.bitmapData != null ? this.bitmapData.hashCode() : 0;
        return this.imageUrl.hashCode() + bitmapHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageData)) {
            return false;
        }
        ImageData i = (ImageData)o;
        if (this.hashCode() != i.hashCode()) {
            return false;
        }
        return this.imageUrl.equals(i.imageUrl);
    }

    public ImageData(@NonNull String imageUrl, @Nullable Bitmap bitmapData) {
        this.imageUrl = imageUrl;
        this.bitmapData = bitmapData;
    }

    @NonNull
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Nullable
    public Bitmap getBitmapData() {
        return this.bitmapData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private String imageUrl;
        @Nullable
        private Bitmap bitmapData;

        public Builder setImageUrl(@Nullable String imageUrl) {
            if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
                this.imageUrl = imageUrl;
            }
            return this;
        }

        public Builder setBitmapData(@Nullable Bitmap bitmapData) {
            this.bitmapData = bitmapData;
            return this;
        }

        public ImageData build() {
            if (TextUtils.isEmpty((CharSequence)this.imageUrl)) {
                throw new IllegalArgumentException("ImageData model must have an imageUrl");
            }
            return new ImageData(this.imageUrl, this.bitmapData);
        }
    }
}

