/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.model;

import androidx.annotation.NonNull;
import com.google.firebase.inappmessaging.model.Action;
import com.google.firebase.inappmessaging.model.CampaignMetadata;
import com.google.firebase.inappmessaging.model.ImageData;
import com.google.firebase.inappmessaging.model.InAppMessage;
import com.google.firebase.inappmessaging.model.MessageType;
import java.util.Map;
import javax.annotation.Nullable;

public class ImageOnlyMessage
extends InAppMessage {
    @NonNull
    private ImageData imageData;
    @Nullable
    private Action action;

    public int hashCode() {
        int actionHash = this.action != null ? this.action.hashCode() : 0;
        return this.imageData.hashCode() + actionHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageOnlyMessage)) {
            return false;
        }
        ImageOnlyMessage i = (ImageOnlyMessage)o;
        if (this.hashCode() != i.hashCode()) {
            return false;
        }
        if (this.action == null && i.action != null || this.action != null && !this.action.equals(i.action)) {
            return false;
        }
        return this.imageData.equals(i.imageData);
    }

    private ImageOnlyMessage(@NonNull CampaignMetadata campaignMetadata, @NonNull ImageData imageData, @Nullable Action action, @Nullable Map<String, String> data) {
        super(campaignMetadata, MessageType.IMAGE_ONLY, data);
        this.imageData = imageData;
        this.action = action;
    }

    @Override
    @NonNull
    public ImageData getImageData() {
        return this.imageData;
    }

    @Override
    @Nullable
    public Action getAction() {
        return this.action;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        ImageData imageData;
        @Nullable
        Action action;

        public Builder setImageData(@Nullable ImageData imageData) {
            this.imageData = imageData;
            return this;
        }

        public Builder setAction(@Nullable Action action) {
            this.action = action;
            return this;
        }

        public ImageOnlyMessage build(CampaignMetadata campaignMetadata, @Nullable Map<String, String> data) {
            if (this.imageData == null) {
                throw new IllegalArgumentException("ImageOnly model must have image data");
            }
            return new ImageOnlyMessage(campaignMetadata, this.imageData, this.action, data);
        }
    }
}

