/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.FirebaseApp;
import com.google.firebase.annotations.concurrent.Lightweight;
import com.google.firebase.inappmessaging.FirebaseInAppMessagingClickListener;
import com.google.firebase.inappmessaging.FirebaseInAppMessagingDismissListener;
import com.google.firebase.inappmessaging.FirebaseInAppMessagingDisplay;
import com.google.firebase.inappmessaging.FirebaseInAppMessagingDisplayErrorListener;
import com.google.firebase.inappmessaging.FirebaseInAppMessagingImpressionListener;
import com.google.firebase.inappmessaging.internal.DataCollectionHelper;
import com.google.firebase.inappmessaging.internal.DeveloperListenerManager;
import com.google.firebase.inappmessaging.internal.DisplayCallbacksFactory;
import com.google.firebase.inappmessaging.internal.InAppMessageStreamManager;
import com.google.firebase.inappmessaging.internal.Logging;
import com.google.firebase.inappmessaging.internal.ProgramaticContextualTriggers;
import com.google.firebase.inappmessaging.internal.injection.qualifiers.ProgrammaticTrigger;
import com.google.firebase.inappmessaging.internal.injection.scopes.FirebaseAppScope;
import com.google.firebase.inappmessaging.model.TriggeredInAppMessage;
import com.google.firebase.installations.FirebaseInstallationsApi;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.Executor;
import javax.inject.Inject;

@FirebaseAppScope
public class FirebaseInAppMessaging {
    private final InAppMessageStreamManager inAppMessageStreamManager;
    private final DataCollectionHelper dataCollectionHelper;
    private final DisplayCallbacksFactory displayCallbacksFactory;
    private final DeveloperListenerManager developerListenerManager;
    private final ProgramaticContextualTriggers programaticContextualTriggers;
    private final FirebaseInstallationsApi firebaseInstallations;
    private boolean areMessagesSuppressed;
    private FirebaseInAppMessagingDisplay fiamDisplay;
    @Lightweight
    private Executor lightWeightExecutor;

    @Inject
    @VisibleForTesting
    FirebaseInAppMessaging(InAppMessageStreamManager inAppMessageStreamManager, @ProgrammaticTrigger ProgramaticContextualTriggers programaticContextualTriggers, DataCollectionHelper dataCollectionHelper, FirebaseInstallationsApi firebaseInstallations, DisplayCallbacksFactory displayCallbacksFactory, DeveloperListenerManager developerListenerManager, @Lightweight Executor lightWeightExecutor) {
        this.inAppMessageStreamManager = inAppMessageStreamManager;
        this.programaticContextualTriggers = programaticContextualTriggers;
        this.dataCollectionHelper = dataCollectionHelper;
        this.firebaseInstallations = firebaseInstallations;
        this.areMessagesSuppressed = false;
        this.displayCallbacksFactory = displayCallbacksFactory;
        this.developerListenerManager = developerListenerManager;
        this.lightWeightExecutor = lightWeightExecutor;
        firebaseInstallations.getId().addOnSuccessListener(lightWeightExecutor, id -> Logging.logi("Starting InAppMessaging runtime with Installation ID " + id));
        Disposable unused = inAppMessageStreamManager.createFirebaseInAppMessageStream().subscribe(this::triggerInAppMessage);
    }

    @NonNull
    public static FirebaseInAppMessaging getInstance() {
        return (FirebaseInAppMessaging)FirebaseApp.getInstance().get(FirebaseInAppMessaging.class);
    }

    public boolean isAutomaticDataCollectionEnabled() {
        return this.dataCollectionHelper.isAutomaticDataCollectionEnabled();
    }

    public void setAutomaticDataCollectionEnabled(@Nullable Boolean isAutomaticCollectionEnabled) {
        this.dataCollectionHelper.setAutomaticDataCollectionEnabled(isAutomaticCollectionEnabled);
    }

    public void setAutomaticDataCollectionEnabled(boolean isAutomaticCollectionEnabled) {
        this.dataCollectionHelper.setAutomaticDataCollectionEnabled(isAutomaticCollectionEnabled);
    }

    public void setMessagesSuppressed(@NonNull Boolean areMessagesSuppressed) {
        this.areMessagesSuppressed = areMessagesSuppressed;
    }

    public boolean areMessagesSuppressed() {
        return this.areMessagesSuppressed;
    }

    public void setMessageDisplayComponent(@NonNull FirebaseInAppMessagingDisplay messageDisplay) {
        Logging.logi("Setting display event component");
        this.fiamDisplay = messageDisplay;
    }

    public void clearDisplayListener() {
        Logging.logi("Removing display event component");
        this.fiamDisplay = null;
    }

    public void addImpressionListener(@NonNull FirebaseInAppMessagingImpressionListener impressionListener) {
        this.developerListenerManager.addImpressionListener(impressionListener);
    }

    public void addClickListener(@NonNull FirebaseInAppMessagingClickListener clickListener) {
        this.developerListenerManager.addClickListener(clickListener);
    }

    public void addDismissListener(@NonNull FirebaseInAppMessagingDismissListener dismissListener) {
        this.developerListenerManager.addDismissListener(dismissListener);
    }

    public void addDisplayErrorListener(@NonNull FirebaseInAppMessagingDisplayErrorListener displayErrorListener) {
        this.developerListenerManager.addDisplayErrorListener(displayErrorListener);
    }

    public void addImpressionListener(@NonNull FirebaseInAppMessagingImpressionListener impressionListener, @NonNull Executor executor) {
        this.developerListenerManager.addImpressionListener(impressionListener, executor);
    }

    public void addClickListener(@NonNull FirebaseInAppMessagingClickListener clickListener, @NonNull Executor executor) {
        this.developerListenerManager.addClickListener(clickListener, executor);
    }

    public void addDismissListener(@NonNull FirebaseInAppMessagingDismissListener dismissListener, @NonNull Executor executor) {
        this.developerListenerManager.addDismissListener(dismissListener, executor);
    }

    public void addDisplayErrorListener(@NonNull FirebaseInAppMessagingDisplayErrorListener displayErrorListener, @NonNull Executor executor) {
        this.developerListenerManager.addDisplayErrorListener(displayErrorListener, executor);
    }

    public void removeImpressionListener(@NonNull FirebaseInAppMessagingImpressionListener impressionListener) {
        this.developerListenerManager.removeImpressionListener(impressionListener);
    }

    public void removeClickListener(@NonNull FirebaseInAppMessagingClickListener clickListener) {
        this.developerListenerManager.removeClickListener(clickListener);
    }

    public void removeDisplayErrorListener(@NonNull FirebaseInAppMessagingDisplayErrorListener displayErrorListener) {
        this.developerListenerManager.removeDisplayErrorListener(displayErrorListener);
    }

    public void removeDismissListener(@NonNull FirebaseInAppMessagingDismissListener dismissListener) {
        this.developerListenerManager.removeDismissListener(dismissListener);
    }

    public void removeAllListeners() {
        this.developerListenerManager.removeAllListeners();
    }

    public void triggerEvent(@NonNull String eventName) {
        this.programaticContextualTriggers.triggerEvent(eventName);
    }

    private void triggerInAppMessage(TriggeredInAppMessage inAppMessage) {
        if (this.fiamDisplay != null) {
            this.fiamDisplay.displayMessage(inAppMessage.getInAppMessage(), this.displayCallbacksFactory.generateDisplayCallback(inAppMessage.getInAppMessage(), inAppMessage.getTriggeringEvent()));
        }
    }
}

