/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal;

import android.app.Application;
import com.google.firebase.inappmessaging.internal.ProtoStorageClient;
import com.google.firebase.inappmessaging.internal.injection.qualifiers.CampaignCache;
import com.google.firebase.inappmessaging.internal.time.Clock;
import com.google.internal.firebase.inappmessaging.v1.sdkserving.FetchEligibleCampaignsResponse;
import com.google.protobuf.AbstractMessageLite;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@ThreadSafe
public class CampaignCacheClient {
    private final ProtoStorageClient storageClient;
    private final Application application;
    private final Clock clock;
    @Nullable
    private FetchEligibleCampaignsResponse cachedResponse;

    @Inject
    CampaignCacheClient(@CampaignCache ProtoStorageClient storageClient, Application application, Clock clock) {
        this.storageClient = storageClient;
        this.application = application;
        this.clock = clock;
    }

    public Completable put(FetchEligibleCampaignsResponse fetchEligibleCampaignsResponse) {
        return this.storageClient.write((AbstractMessageLite)fetchEligibleCampaignsResponse).doOnComplete(() -> {
            this.cachedResponse = fetchEligibleCampaignsResponse;
        });
    }

    public Maybe<FetchEligibleCampaignsResponse> get() {
        Maybe readFromCache = Maybe.fromCallable(() -> this.cachedResponse);
        Maybe readFromStorage = this.storageClient.read(FetchEligibleCampaignsResponse.parser()).doOnSuccess(response -> {
            this.cachedResponse = response;
        });
        return readFromCache.switchIfEmpty((MaybeSource)readFromStorage).filter(this::isResponseValid).doOnError(s -> {
            this.cachedResponse = null;
        });
    }

    private boolean isResponseValid(FetchEligibleCampaignsResponse response) {
        long expirationTimestamp = response.getExpirationEpochTimestampMillis();
        long currentTime = this.clock.now();
        File file = new File(this.application.getApplicationContext().getFilesDir(), "fiam_eligible_campaigns_cache_file");
        if (expirationTimestamp != 0L) {
            return currentTime < expirationTimestamp;
        }
        if (file.exists()) {
            return currentTime < file.lastModified() + TimeUnit.DAYS.toMillis(1L);
        }
        return true;
    }
}

