/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal.injection.components;

import android.app.Application;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.events.Subscriber;
import com.google.firebase.inappmessaging.dagger.internal.DaggerGenerated;
import com.google.firebase.inappmessaging.dagger.internal.DoubleCheck;
import com.google.firebase.inappmessaging.dagger.internal.Preconditions;
import com.google.firebase.inappmessaging.internal.AnalyticsEventsManager;
import com.google.firebase.inappmessaging.internal.CampaignCacheClient;
import com.google.firebase.inappmessaging.internal.CampaignCacheClient_Factory;
import com.google.firebase.inappmessaging.internal.DeveloperListenerManager;
import com.google.firebase.inappmessaging.internal.ImpressionStorageClient;
import com.google.firebase.inappmessaging.internal.ImpressionStorageClient_Factory;
import com.google.firebase.inappmessaging.internal.ProgramaticContextualTriggers;
import com.google.firebase.inappmessaging.internal.ProtoStorageClient;
import com.google.firebase.inappmessaging.internal.ProviderInstaller;
import com.google.firebase.inappmessaging.internal.ProviderInstaller_Factory;
import com.google.firebase.inappmessaging.internal.RateLimiterClient;
import com.google.firebase.inappmessaging.internal.RateLimiterClient_Factory;
import com.google.firebase.inappmessaging.internal.Schedulers;
import com.google.firebase.inappmessaging.internal.Schedulers_Factory;
import com.google.firebase.inappmessaging.internal.injection.components.UniversalComponent;
import com.google.firebase.inappmessaging.internal.injection.modules.AnalyticsEventsModule;
import com.google.firebase.inappmessaging.internal.injection.modules.AnalyticsEventsModule_ProvidesAnalyticsConnectorEventsFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.AnalyticsEventsModule_ProvidesAnalyticsEventsManagerFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.AppMeasurementModule;
import com.google.firebase.inappmessaging.internal.injection.modules.AppMeasurementModule_ProvidesAnalyticsConnectorFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.AppMeasurementModule_ProvidesSubsriberFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ApplicationModule;
import com.google.firebase.inappmessaging.internal.injection.modules.ApplicationModule_DeveloperListenerManagerFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ApplicationModule_ProvidesApplicationFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ExecutorsModule;
import com.google.firebase.inappmessaging.internal.injection.modules.ExecutorsModule_ProvidesBackgroundExecutorFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ExecutorsModule_ProvidesBlockingExecutorFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ExecutorsModule_ProvidesLightWeightExecutorFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ForegroundFlowableModule;
import com.google.firebase.inappmessaging.internal.injection.modules.ForegroundFlowableModule_ProvidesAppForegroundEventStreamFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.GrpcChannelModule;
import com.google.firebase.inappmessaging.internal.injection.modules.GrpcChannelModule_ProvidesGrpcChannelFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.GrpcChannelModule_ProvidesServiceHostFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ProgrammaticContextualTriggerFlowableModule;
import com.google.firebase.inappmessaging.internal.injection.modules.ProgrammaticContextualTriggerFlowableModule_ProvidesProgramaticContextualTriggerStreamFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ProgrammaticContextualTriggerFlowableModule_ProvidesProgramaticContextualTriggersFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ProtoStorageClientModule;
import com.google.firebase.inappmessaging.internal.injection.modules.ProtoStorageClientModule_ProvidesProtoStorageClientForCampaignFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ProtoStorageClientModule_ProvidesProtoStorageClientForImpressionStoreFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ProtoStorageClientModule_ProvidesProtoStorageClientForLimiterStoreFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.RateLimitModule;
import com.google.firebase.inappmessaging.internal.injection.modules.RateLimitModule_ProvidesAppForegroundRateLimitFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.SchedulerModule;
import com.google.firebase.inappmessaging.internal.injection.modules.SchedulerModule_ProvidesComputeSchedulerFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.SchedulerModule_ProvidesIOSchedulerFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.SchedulerModule_ProvidesMainThreadSchedulerFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.SystemClockModule;
import com.google.firebase.inappmessaging.internal.injection.modules.SystemClockModule_ProvidesSystemClockModuleFactory;
import com.google.firebase.inappmessaging.internal.time.Clock;
import com.google.firebase.inappmessaging.model.ProtoMarshallerClient;
import com.google.firebase.inappmessaging.model.ProtoMarshallerClient_Factory;
import com.google.firebase.inappmessaging.model.RateLimit;
import io.grpc.Channel;
import io.reactivex.Scheduler;
import io.reactivex.flowables.ConnectableFlowable;
import java.util.concurrent.Executor;
import javax.inject.Provider;

@DaggerGenerated
public final class DaggerUniversalComponent {
    private DaggerUniversalComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class UniversalComponentImpl
    implements UniversalComponent {
        private final SystemClockModule systemClockModule;
        private final RateLimitModule rateLimitModule;
        private final UniversalComponentImpl universalComponentImpl = this;
        private Provider<Application> providesApplicationProvider;
        private Provider<ProviderInstaller> providerInstallerProvider;
        private Provider<String> providesServiceHostProvider;
        private Provider<Channel> providesGrpcChannelProvider;
        private Provider<Scheduler> providesIOSchedulerProvider;
        private Provider<Scheduler> providesComputeSchedulerProvider;
        private Provider<Scheduler> providesMainThreadSchedulerProvider;
        private Provider<Schedulers> schedulersProvider;
        private Provider<ConnectableFlowable<String>> providesAppForegroundEventStreamProvider;
        private Provider<ConnectableFlowable<String>> providesProgramaticContextualTriggerStreamProvider;
        private Provider<ProgramaticContextualTriggers> providesProgramaticContextualTriggersProvider;
        private Provider<AnalyticsConnector> providesAnalyticsConnectorProvider;
        private Provider<AnalyticsEventsManager> providesAnalyticsEventsManagerProvider;
        private Provider<ConnectableFlowable<String>> providesAnalyticsConnectorEventsProvider;
        private Provider<Subscriber> providesSubsriberProvider;
        private Provider<ProtoStorageClient> providesProtoStorageClientForCampaignProvider;
        private Provider<Clock> providesSystemClockModuleProvider;
        private Provider<CampaignCacheClient> campaignCacheClientProvider;
        private Provider<ProtoStorageClient> providesProtoStorageClientForImpressionStoreProvider;
        private Provider<ImpressionStorageClient> impressionStorageClientProvider;
        private Provider<ProtoMarshallerClient> protoMarshallerClientProvider;
        private Provider<ProtoStorageClient> providesProtoStorageClientForLimiterStoreProvider;
        private Provider<RateLimiterClient> rateLimiterClientProvider;
        private Provider<Executor> providesBackgroundExecutorProvider;
        private Provider<DeveloperListenerManager> developerListenerManagerProvider;
        private Provider<Executor> providesLightWeightExecutorProvider;
        private Provider<Executor> providesBlockingExecutorProvider;

        private UniversalComponentImpl(GrpcChannelModule grpcChannelModuleParam, SchedulerModule schedulerModuleParam, ApplicationModule applicationModuleParam, ForegroundFlowableModule foregroundFlowableModuleParam, ProgrammaticContextualTriggerFlowableModule programmaticContextualTriggerFlowableModuleParam, AnalyticsEventsModule analyticsEventsModuleParam, ProtoStorageClientModule protoStorageClientModuleParam, SystemClockModule systemClockModuleParam, RateLimitModule rateLimitModuleParam, AppMeasurementModule appMeasurementModuleParam, ExecutorsModule executorsModuleParam) {
            this.systemClockModule = systemClockModuleParam;
            this.rateLimitModule = rateLimitModuleParam;
            this.initialize(grpcChannelModuleParam, schedulerModuleParam, applicationModuleParam, foregroundFlowableModuleParam, programmaticContextualTriggerFlowableModuleParam, analyticsEventsModuleParam, protoStorageClientModuleParam, systemClockModuleParam, rateLimitModuleParam, appMeasurementModuleParam, executorsModuleParam);
        }

        private void initialize(GrpcChannelModule grpcChannelModuleParam, SchedulerModule schedulerModuleParam, ApplicationModule applicationModuleParam, ForegroundFlowableModule foregroundFlowableModuleParam, ProgrammaticContextualTriggerFlowableModule programmaticContextualTriggerFlowableModuleParam, AnalyticsEventsModule analyticsEventsModuleParam, ProtoStorageClientModule protoStorageClientModuleParam, SystemClockModule systemClockModuleParam, RateLimitModule rateLimitModuleParam, AppMeasurementModule appMeasurementModuleParam, ExecutorsModule executorsModuleParam) {
            this.providesApplicationProvider = DoubleCheck.provider(ApplicationModule_ProvidesApplicationFactory.create(applicationModuleParam));
            this.providerInstallerProvider = DoubleCheck.provider(ProviderInstaller_Factory.create(this.providesApplicationProvider));
            this.providesServiceHostProvider = DoubleCheck.provider(GrpcChannelModule_ProvidesServiceHostFactory.create(grpcChannelModuleParam));
            this.providesGrpcChannelProvider = DoubleCheck.provider(GrpcChannelModule_ProvidesGrpcChannelFactory.create(grpcChannelModuleParam, this.providesServiceHostProvider));
            this.providesIOSchedulerProvider = DoubleCheck.provider(SchedulerModule_ProvidesIOSchedulerFactory.create(schedulerModuleParam));
            this.providesComputeSchedulerProvider = DoubleCheck.provider(SchedulerModule_ProvidesComputeSchedulerFactory.create(schedulerModuleParam));
            this.providesMainThreadSchedulerProvider = DoubleCheck.provider(SchedulerModule_ProvidesMainThreadSchedulerFactory.create(schedulerModuleParam));
            this.schedulersProvider = DoubleCheck.provider(Schedulers_Factory.create(this.providesIOSchedulerProvider, this.providesComputeSchedulerProvider, this.providesMainThreadSchedulerProvider));
            this.providesAppForegroundEventStreamProvider = DoubleCheck.provider(ForegroundFlowableModule_ProvidesAppForegroundEventStreamFactory.create(foregroundFlowableModuleParam, this.providesApplicationProvider));
            this.providesProgramaticContextualTriggerStreamProvider = DoubleCheck.provider(ProgrammaticContextualTriggerFlowableModule_ProvidesProgramaticContextualTriggerStreamFactory.create(programmaticContextualTriggerFlowableModuleParam));
            this.providesProgramaticContextualTriggersProvider = DoubleCheck.provider(ProgrammaticContextualTriggerFlowableModule_ProvidesProgramaticContextualTriggersFactory.create(programmaticContextualTriggerFlowableModuleParam));
            this.providesAnalyticsConnectorProvider = DoubleCheck.provider(AppMeasurementModule_ProvidesAnalyticsConnectorFactory.create(appMeasurementModuleParam));
            this.providesAnalyticsEventsManagerProvider = DoubleCheck.provider(AnalyticsEventsModule_ProvidesAnalyticsEventsManagerFactory.create(analyticsEventsModuleParam, this.providesAnalyticsConnectorProvider));
            this.providesAnalyticsConnectorEventsProvider = DoubleCheck.provider(AnalyticsEventsModule_ProvidesAnalyticsConnectorEventsFactory.create(analyticsEventsModuleParam, this.providesAnalyticsEventsManagerProvider));
            this.providesSubsriberProvider = DoubleCheck.provider(AppMeasurementModule_ProvidesSubsriberFactory.create(appMeasurementModuleParam));
            this.providesProtoStorageClientForCampaignProvider = DoubleCheck.provider(ProtoStorageClientModule_ProvidesProtoStorageClientForCampaignFactory.create(protoStorageClientModuleParam, this.providesApplicationProvider));
            this.providesSystemClockModuleProvider = SystemClockModule_ProvidesSystemClockModuleFactory.create(systemClockModuleParam);
            this.campaignCacheClientProvider = DoubleCheck.provider(CampaignCacheClient_Factory.create(this.providesProtoStorageClientForCampaignProvider, this.providesApplicationProvider, this.providesSystemClockModuleProvider));
            this.providesProtoStorageClientForImpressionStoreProvider = DoubleCheck.provider(ProtoStorageClientModule_ProvidesProtoStorageClientForImpressionStoreFactory.create(protoStorageClientModuleParam, this.providesApplicationProvider));
            this.impressionStorageClientProvider = DoubleCheck.provider(ImpressionStorageClient_Factory.create(this.providesProtoStorageClientForImpressionStoreProvider));
            this.protoMarshallerClientProvider = DoubleCheck.provider(ProtoMarshallerClient_Factory.create());
            this.providesProtoStorageClientForLimiterStoreProvider = DoubleCheck.provider(ProtoStorageClientModule_ProvidesProtoStorageClientForLimiterStoreFactory.create(protoStorageClientModuleParam, this.providesApplicationProvider));
            this.rateLimiterClientProvider = DoubleCheck.provider(RateLimiterClient_Factory.create(this.providesProtoStorageClientForLimiterStoreProvider, this.providesSystemClockModuleProvider));
            this.providesBackgroundExecutorProvider = DoubleCheck.provider(ExecutorsModule_ProvidesBackgroundExecutorFactory.create(executorsModuleParam));
            this.developerListenerManagerProvider = DoubleCheck.provider(ApplicationModule_DeveloperListenerManagerFactory.create(applicationModuleParam, this.providesBackgroundExecutorProvider));
            this.providesLightWeightExecutorProvider = DoubleCheck.provider(ExecutorsModule_ProvidesLightWeightExecutorFactory.create(executorsModuleParam));
            this.providesBlockingExecutorProvider = DoubleCheck.provider(ExecutorsModule_ProvidesBlockingExecutorFactory.create(executorsModuleParam));
        }

        @Override
        public ProviderInstaller providerInstaller() {
            return (ProviderInstaller)this.providerInstallerProvider.get();
        }

        @Override
        public Channel gRPCChannel() {
            return (Channel)this.providesGrpcChannelProvider.get();
        }

        @Override
        public Schedulers schedulers() {
            return (Schedulers)this.schedulersProvider.get();
        }

        @Override
        public ConnectableFlowable<String> appForegroundEventFlowable() {
            return (ConnectableFlowable)this.providesAppForegroundEventStreamProvider.get();
        }

        @Override
        public ConnectableFlowable<String> programmaticContextualTriggerFlowable() {
            return (ConnectableFlowable)this.providesProgramaticContextualTriggerStreamProvider.get();
        }

        @Override
        public ProgramaticContextualTriggers programmaticContextualTriggers() {
            return (ProgramaticContextualTriggers)this.providesProgramaticContextualTriggersProvider.get();
        }

        @Override
        public ConnectableFlowable<String> analyticsEventsFlowable() {
            return (ConnectableFlowable)this.providesAnalyticsConnectorEventsProvider.get();
        }

        @Override
        public AnalyticsEventsManager analyticsEventsManager() {
            return (AnalyticsEventsManager)this.providesAnalyticsEventsManagerProvider.get();
        }

        @Override
        public AnalyticsConnector analyticsConnector() {
            return (AnalyticsConnector)this.providesAnalyticsConnectorProvider.get();
        }

        @Override
        public Subscriber firebaseEventsSubscriber() {
            return (Subscriber)this.providesSubsriberProvider.get();
        }

        @Override
        public CampaignCacheClient campaignCacheClient() {
            return (CampaignCacheClient)this.campaignCacheClientProvider.get();
        }

        @Override
        public ImpressionStorageClient impressionStorageClient() {
            return (ImpressionStorageClient)this.impressionStorageClientProvider.get();
        }

        @Override
        public Clock clock() {
            return SystemClockModule_ProvidesSystemClockModuleFactory.providesSystemClockModule(this.systemClockModule);
        }

        @Override
        public ProtoMarshallerClient protoMarshallerClient() {
            return (ProtoMarshallerClient)this.protoMarshallerClientProvider.get();
        }

        @Override
        public RateLimiterClient rateLimiterClient() {
            return (RateLimiterClient)this.rateLimiterClientProvider.get();
        }

        @Override
        public Application application() {
            return (Application)this.providesApplicationProvider.get();
        }

        @Override
        public RateLimit appForegroundRateLimit() {
            return RateLimitModule_ProvidesAppForegroundRateLimitFactory.providesAppForegroundRateLimit(this.rateLimitModule);
        }

        @Override
        public DeveloperListenerManager developerListenerManager() {
            return (DeveloperListenerManager)this.developerListenerManagerProvider.get();
        }

        @Override
        public Executor lightWeightExecutor() {
            return (Executor)this.providesLightWeightExecutorProvider.get();
        }

        @Override
        public Executor blockingExecutor() {
            return (Executor)this.providesBlockingExecutorProvider.get();
        }
    }

    public static final class Builder {
        private GrpcChannelModule grpcChannelModule;
        private SchedulerModule schedulerModule;
        private ApplicationModule applicationModule;
        private ForegroundFlowableModule foregroundFlowableModule;
        private ProgrammaticContextualTriggerFlowableModule programmaticContextualTriggerFlowableModule;
        private AnalyticsEventsModule analyticsEventsModule;
        private ProtoStorageClientModule protoStorageClientModule;
        private SystemClockModule systemClockModule;
        private RateLimitModule rateLimitModule;
        private AppMeasurementModule appMeasurementModule;
        private ExecutorsModule executorsModule;

        private Builder() {
        }

        public Builder grpcChannelModule(GrpcChannelModule grpcChannelModule) {
            this.grpcChannelModule = Preconditions.checkNotNull(grpcChannelModule);
            return this;
        }

        public Builder schedulerModule(SchedulerModule schedulerModule) {
            this.schedulerModule = Preconditions.checkNotNull(schedulerModule);
            return this;
        }

        public Builder applicationModule(ApplicationModule applicationModule) {
            this.applicationModule = Preconditions.checkNotNull(applicationModule);
            return this;
        }

        public Builder foregroundFlowableModule(ForegroundFlowableModule foregroundFlowableModule) {
            this.foregroundFlowableModule = Preconditions.checkNotNull(foregroundFlowableModule);
            return this;
        }

        public Builder programmaticContextualTriggerFlowableModule(ProgrammaticContextualTriggerFlowableModule programmaticContextualTriggerFlowableModule) {
            this.programmaticContextualTriggerFlowableModule = Preconditions.checkNotNull(programmaticContextualTriggerFlowableModule);
            return this;
        }

        public Builder analyticsEventsModule(AnalyticsEventsModule analyticsEventsModule) {
            this.analyticsEventsModule = Preconditions.checkNotNull(analyticsEventsModule);
            return this;
        }

        public Builder protoStorageClientModule(ProtoStorageClientModule protoStorageClientModule) {
            this.protoStorageClientModule = Preconditions.checkNotNull(protoStorageClientModule);
            return this;
        }

        public Builder systemClockModule(SystemClockModule systemClockModule) {
            this.systemClockModule = Preconditions.checkNotNull(systemClockModule);
            return this;
        }

        public Builder rateLimitModule(RateLimitModule rateLimitModule) {
            this.rateLimitModule = Preconditions.checkNotNull(rateLimitModule);
            return this;
        }

        public Builder appMeasurementModule(AppMeasurementModule appMeasurementModule) {
            this.appMeasurementModule = Preconditions.checkNotNull(appMeasurementModule);
            return this;
        }

        public Builder executorsModule(ExecutorsModule executorsModule) {
            this.executorsModule = Preconditions.checkNotNull(executorsModule);
            return this;
        }

        public UniversalComponent build() {
            if (this.grpcChannelModule == null) {
                this.grpcChannelModule = new GrpcChannelModule();
            }
            if (this.schedulerModule == null) {
                this.schedulerModule = new SchedulerModule();
            }
            Preconditions.checkBuilderRequirement(this.applicationModule, ApplicationModule.class);
            if (this.foregroundFlowableModule == null) {
                this.foregroundFlowableModule = new ForegroundFlowableModule();
            }
            Preconditions.checkBuilderRequirement(this.programmaticContextualTriggerFlowableModule, ProgrammaticContextualTriggerFlowableModule.class);
            if (this.analyticsEventsModule == null) {
                this.analyticsEventsModule = new AnalyticsEventsModule();
            }
            if (this.protoStorageClientModule == null) {
                this.protoStorageClientModule = new ProtoStorageClientModule();
            }
            if (this.systemClockModule == null) {
                this.systemClockModule = new SystemClockModule();
            }
            if (this.rateLimitModule == null) {
                this.rateLimitModule = new RateLimitModule();
            }
            Preconditions.checkBuilderRequirement(this.appMeasurementModule, AppMeasurementModule.class);
            Preconditions.checkBuilderRequirement(this.executorsModule, ExecutorsModule.class);
            return new UniversalComponentImpl(this.grpcChannelModule, this.schedulerModule, this.applicationModule, this.foregroundFlowableModule, this.programmaticContextualTriggerFlowableModule, this.analyticsEventsModule, this.protoStorageClientModule, this.systemClockModule, this.rateLimitModule, this.appMeasurementModule, this.executorsModule);
        }
    }
}

