/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.network;

import androidx.annotation.Keep;
import com.google.firebase.perf.metrics.NetworkRequestMetricBuilder;
import com.google.firebase.perf.network.InstrHttpURLConnection;
import com.google.firebase.perf.network.InstrHttpsURLConnection;
import com.google.firebase.perf.network.NetworkRequestMetricBuilderUtil;
import com.google.firebase.perf.transport.TransportManager;
import com.google.firebase.perf.util.Timer;
import com.google.firebase.perf.util.URLWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;

public class FirebasePerfUrlConnection {
    private FirebasePerfUrlConnection() {
    }

    @Keep
    public static InputStream openStream(URL url) throws IOException {
        return FirebasePerfUrlConnection.openStream(new URLWrapper(url), TransportManager.getInstance(), new Timer());
    }

    static InputStream openStream(URLWrapper wrapper, TransportManager transportManager, Timer timer) throws IOException {
        if (!TransportManager.getInstance().isInitialized()) {
            return wrapper.openConnection().getInputStream();
        }
        timer.reset();
        long startTime = timer.getMicros();
        NetworkRequestMetricBuilder builder = NetworkRequestMetricBuilder.builder(transportManager);
        try {
            URLConnection connection = wrapper.openConnection();
            if (connection instanceof HttpsURLConnection) {
                return new InstrHttpsURLConnection((HttpsURLConnection)connection, timer, builder).getInputStream();
            }
            if (connection instanceof HttpURLConnection) {
                return new InstrHttpURLConnection((HttpURLConnection)connection, timer, builder).getInputStream();
            }
            return connection.getInputStream();
        }
        catch (IOException e) {
            builder.setRequestStartTimeMicros(startTime);
            builder.setTimeToResponseCompletedMicros(timer.getDurationMicros());
            builder.setUrl(wrapper.toString());
            NetworkRequestMetricBuilderUtil.logError(builder);
            throw e;
        }
    }

    @Keep
    public static Object getContent(URL url) throws IOException {
        return FirebasePerfUrlConnection.getContent(new URLWrapper(url), TransportManager.getInstance(), new Timer());
    }

    @Keep
    public static Object getContent(URL url, Class[] types) throws IOException {
        return FirebasePerfUrlConnection.getContent(new URLWrapper(url), types, TransportManager.getInstance(), new Timer());
    }

    static Object getContent(URLWrapper wrapper, TransportManager transportManager, Timer timer) throws IOException {
        timer.reset();
        long startTime = timer.getMicros();
        NetworkRequestMetricBuilder builder = NetworkRequestMetricBuilder.builder(transportManager);
        try {
            URLConnection connection = wrapper.openConnection();
            if (connection instanceof HttpsURLConnection) {
                return new InstrHttpsURLConnection((HttpsURLConnection)connection, timer, builder).getContent();
            }
            if (connection instanceof HttpURLConnection) {
                return new InstrHttpURLConnection((HttpURLConnection)connection, timer, builder).getContent();
            }
            return connection.getContent();
        }
        catch (IOException e) {
            builder.setRequestStartTimeMicros(startTime);
            builder.setTimeToResponseCompletedMicros(timer.getDurationMicros());
            builder.setUrl(wrapper.toString());
            NetworkRequestMetricBuilderUtil.logError(builder);
            throw e;
        }
    }

    static Object getContent(URLWrapper wrapper, Class[] types, TransportManager transportManager, Timer timer) throws IOException {
        timer.reset();
        long startTime = timer.getMicros();
        NetworkRequestMetricBuilder builder = NetworkRequestMetricBuilder.builder(transportManager);
        try {
            URLConnection connection = wrapper.openConnection();
            if (connection instanceof HttpsURLConnection) {
                return new InstrHttpsURLConnection((HttpsURLConnection)connection, timer, builder).getContent(types);
            }
            if (connection instanceof HttpURLConnection) {
                return new InstrHttpURLConnection((HttpURLConnection)connection, timer, builder).getContent(types);
            }
            return connection.getContent(types);
        }
        catch (IOException e) {
            builder.setRequestStartTimeMicros(startTime);
            builder.setTimeToResponseCompletedMicros(timer.getDurationMicros());
            builder.setUrl(wrapper.toString());
            NetworkRequestMetricBuilderUtil.logError(builder);
            throw e;
        }
    }

    @Keep
    public static Object instrument(Object connection) throws IOException {
        if (connection instanceof HttpsURLConnection) {
            return new InstrHttpsURLConnection((HttpsURLConnection)connection, new Timer(), NetworkRequestMetricBuilder.builder(TransportManager.getInstance()));
        }
        if (connection instanceof HttpURLConnection) {
            return new InstrHttpURLConnection((HttpURLConnection)connection, new Timer(), NetworkRequestMetricBuilder.builder(TransportManager.getInstance()));
        }
        return connection;
    }
}

