/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data.geojson;

import android.util.Log;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.maps.android.data.Geometry;
import com.google.maps.android.data.geojson.GeoJsonFeature;
import com.google.maps.android.data.geojson.GeoJsonGeometryCollection;
import com.google.maps.android.data.geojson.GeoJsonLineString;
import com.google.maps.android.data.geojson.GeoJsonMultiLineString;
import com.google.maps.android.data.geojson.GeoJsonMultiPoint;
import com.google.maps.android.data.geojson.GeoJsonMultiPolygon;
import com.google.maps.android.data.geojson.GeoJsonPoint;
import com.google.maps.android.data.geojson.GeoJsonPolygon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GeoJsonParser {
    private static final String LOG_TAG = "GeoJsonParser";
    private static final String FEATURE = "Feature";
    private static final String FEATURE_GEOMETRY = "geometry";
    private static final String FEATURE_ID = "id";
    private static final String FEATURE_COLLECTION = "FeatureCollection";
    private static final String FEATURE_COLLECTION_ARRAY = "features";
    private static final String GEOMETRY_COORDINATES_ARRAY = "coordinates";
    private static final String GEOMETRY_COLLECTION = "GeometryCollection";
    private static final String GEOMETRY_COLLECTION_ARRAY = "geometries";
    private static final String BOUNDING_BOX = "bbox";
    private static final String PROPERTIES = "properties";
    private static final String POINT = "Point";
    private static final String MULTIPOINT = "MultiPoint";
    private static final String LINESTRING = "LineString";
    private static final String MULTILINESTRING = "MultiLineString";
    private static final String POLYGON = "Polygon";
    private static final String MULTIPOLYGON = "MultiPolygon";
    private final JSONObject mGeoJsonFile;
    private final ArrayList<GeoJsonFeature> mGeoJsonFeatures;
    private LatLngBounds mBoundingBox;

    GeoJsonParser(JSONObject geoJsonFile) {
        this.mGeoJsonFile = geoJsonFile;
        this.mGeoJsonFeatures = new ArrayList();
        this.mBoundingBox = null;
        this.parseGeoJson();
    }

    private static boolean isGeometry(String type) {
        return type.matches("Point|MultiPoint|LineString|MultiLineString|Polygon|MultiPolygon|GeometryCollection");
    }

    private static GeoJsonFeature parseFeature(JSONObject geoJsonFeature) {
        String id2 = null;
        LatLngBounds boundingBox = null;
        Geometry geometry = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            if (geoJsonFeature.has(FEATURE_ID)) {
                id2 = geoJsonFeature.getString(FEATURE_ID);
            }
            if (geoJsonFeature.has(BOUNDING_BOX)) {
                boundingBox = GeoJsonParser.parseBoundingBox(geoJsonFeature.getJSONArray(BOUNDING_BOX));
            }
            if (geoJsonFeature.has(FEATURE_GEOMETRY) && !geoJsonFeature.isNull(FEATURE_GEOMETRY)) {
                geometry = GeoJsonParser.parseGeometry(geoJsonFeature.getJSONObject(FEATURE_GEOMETRY));
            }
            if (geoJsonFeature.has(PROPERTIES) && !geoJsonFeature.isNull(PROPERTIES)) {
                properties = GeoJsonParser.parseProperties(geoJsonFeature.getJSONObject(PROPERTIES));
            }
        }
        catch (JSONException e) {
            Log.w((String)LOG_TAG, (String)("Feature could not be successfully parsed " + geoJsonFeature.toString()));
            return null;
        }
        return new GeoJsonFeature(geometry, id2, properties, boundingBox);
    }

    private static LatLngBounds parseBoundingBox(JSONArray coordinates) throws JSONException {
        LatLng southWestCorner = new LatLng(coordinates.getDouble(1), coordinates.getDouble(0));
        LatLng northEastCorner = new LatLng(coordinates.getDouble(3), coordinates.getDouble(2));
        return new LatLngBounds(southWestCorner, northEastCorner);
    }

    public static Geometry parseGeometry(JSONObject geoJsonGeometry) {
        try {
            JSONArray geometryArray;
            String geometryType = geoJsonGeometry.getString("type");
            if (geometryType.equals(GEOMETRY_COLLECTION)) {
                geometryArray = geoJsonGeometry.getJSONArray(GEOMETRY_COLLECTION_ARRAY);
            } else if (GeoJsonParser.isGeometry(geometryType)) {
                geometryArray = geoJsonGeometry.getJSONArray(GEOMETRY_COORDINATES_ARRAY);
            } else {
                return null;
            }
            return GeoJsonParser.createGeometry(geometryType, geometryArray);
        }
        catch (JSONException e) {
            return null;
        }
    }

    private static GeoJsonFeature parseGeometryToFeature(JSONObject geoJsonGeometry) {
        Geometry geometry = GeoJsonParser.parseGeometry(geoJsonGeometry);
        if (geometry != null) {
            return new GeoJsonFeature(geometry, null, new HashMap<String, String>(), null);
        }
        Log.w((String)LOG_TAG, (String)"Geometry could not be parsed");
        return null;
    }

    private static HashMap<String, String> parseProperties(JSONObject properties) throws JSONException {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        Iterator propertyKeys = properties.keys();
        while (propertyKeys.hasNext()) {
            String key;
            propertiesMap.put(key, properties.isNull(key = (String)propertyKeys.next()) ? null : properties.getString(key));
        }
        return propertiesMap;
    }

    private static Geometry createGeometry(String geometryType, JSONArray geometryArray) throws JSONException {
        switch (geometryType) {
            case "Point": {
                return GeoJsonParser.createPoint(geometryArray);
            }
            case "MultiPoint": {
                return GeoJsonParser.createMultiPoint(geometryArray);
            }
            case "LineString": {
                return GeoJsonParser.createLineString(geometryArray);
            }
            case "MultiLineString": {
                return GeoJsonParser.createMultiLineString(geometryArray);
            }
            case "Polygon": {
                return GeoJsonParser.createPolygon(geometryArray);
            }
            case "MultiPolygon": {
                return GeoJsonParser.createMultiPolygon(geometryArray);
            }
            case "GeometryCollection": {
                return GeoJsonParser.createGeometryCollection(geometryArray);
            }
        }
        return null;
    }

    private static GeoJsonPoint createPoint(JSONArray coordinates) throws JSONException {
        LatLngAlt latLngAlt = GeoJsonParser.parseCoordinate(coordinates);
        return new GeoJsonPoint(latLngAlt.latLng, latLngAlt.altitude);
    }

    private static GeoJsonMultiPoint createMultiPoint(JSONArray coordinates) throws JSONException {
        ArrayList<GeoJsonPoint> geoJsonPoints = new ArrayList<GeoJsonPoint>();
        for (int i = 0; i < coordinates.length(); ++i) {
            geoJsonPoints.add(GeoJsonParser.createPoint(coordinates.getJSONArray(i)));
        }
        return new GeoJsonMultiPoint((List<GeoJsonPoint>)geoJsonPoints);
    }

    private static GeoJsonLineString createLineString(JSONArray coordinates) throws JSONException {
        ArrayList<LatLngAlt> latLngAlts = GeoJsonParser.parseCoordinatesArray(coordinates);
        ArrayList<LatLng> latLngs = new ArrayList<LatLng>();
        ArrayList<Double> altitudes = new ArrayList<Double>();
        for (LatLngAlt latLngAlt : latLngAlts) {
            latLngs.add(latLngAlt.latLng);
            if (latLngAlt.altitude == null) continue;
            altitudes.add(latLngAlt.altitude);
        }
        return new GeoJsonLineString(latLngs, altitudes);
    }

    private static GeoJsonMultiLineString createMultiLineString(JSONArray coordinates) throws JSONException {
        ArrayList<GeoJsonLineString> geoJsonLineStrings = new ArrayList<GeoJsonLineString>();
        for (int i = 0; i < coordinates.length(); ++i) {
            geoJsonLineStrings.add(GeoJsonParser.createLineString(coordinates.getJSONArray(i)));
        }
        return new GeoJsonMultiLineString((List<GeoJsonLineString>)geoJsonLineStrings);
    }

    private static GeoJsonPolygon createPolygon(JSONArray coordinates) throws JSONException {
        return new GeoJsonPolygon(GeoJsonParser.parseCoordinatesArrays(coordinates));
    }

    private static GeoJsonMultiPolygon createMultiPolygon(JSONArray coordinates) throws JSONException {
        ArrayList<GeoJsonPolygon> geoJsonPolygons = new ArrayList<GeoJsonPolygon>();
        for (int i = 0; i < coordinates.length(); ++i) {
            geoJsonPolygons.add(GeoJsonParser.createPolygon(coordinates.getJSONArray(i)));
        }
        return new GeoJsonMultiPolygon((List<GeoJsonPolygon>)geoJsonPolygons);
    }

    private static GeoJsonGeometryCollection createGeometryCollection(JSONArray geometries) throws JSONException {
        ArrayList<Geometry> geometryCollectionElements = new ArrayList<Geometry>();
        for (int i = 0; i < geometries.length(); ++i) {
            JSONObject geometryElement = geometries.getJSONObject(i);
            Geometry geometry = GeoJsonParser.parseGeometry(geometryElement);
            if (geometry == null) continue;
            geometryCollectionElements.add(geometry);
        }
        return new GeoJsonGeometryCollection((List<Geometry>)geometryCollectionElements);
    }

    private static LatLngAlt parseCoordinate(JSONArray coordinates) throws JSONException {
        LatLng latLng = new LatLng(coordinates.getDouble(1), coordinates.getDouble(0));
        Double altitude = coordinates.length() < 3 ? null : Double.valueOf(coordinates.getDouble(2));
        return new LatLngAlt(latLng, altitude);
    }

    private static ArrayList<LatLngAlt> parseCoordinatesArray(JSONArray coordinates) throws JSONException {
        ArrayList<LatLngAlt> coordinatesArray = new ArrayList<LatLngAlt>();
        for (int i = 0; i < coordinates.length(); ++i) {
            coordinatesArray.add(GeoJsonParser.parseCoordinate(coordinates.getJSONArray(i)));
        }
        return coordinatesArray;
    }

    private static ArrayList<ArrayList<LatLng>> parseCoordinatesArrays(JSONArray coordinates) throws JSONException {
        ArrayList<ArrayList<LatLng>> coordinatesArray = new ArrayList<ArrayList<LatLng>>();
        for (int i = 0; i < coordinates.length(); ++i) {
            ArrayList<LatLngAlt> latLngAlts = GeoJsonParser.parseCoordinatesArray(coordinates.getJSONArray(i));
            ArrayList<LatLng> latLngs = new ArrayList<LatLng>();
            for (LatLngAlt latLngAlt : latLngAlts) {
                latLngs.add(latLngAlt.latLng);
            }
            coordinatesArray.add(latLngs);
        }
        return coordinatesArray;
    }

    private void parseGeoJson() {
        try {
            String type = this.mGeoJsonFile.getString("type");
            if (type.equals(FEATURE)) {
                GeoJsonFeature feature = GeoJsonParser.parseFeature(this.mGeoJsonFile);
                if (feature != null) {
                    this.mGeoJsonFeatures.add(feature);
                }
            } else if (type.equals(FEATURE_COLLECTION)) {
                this.mGeoJsonFeatures.addAll(this.parseFeatureCollection(this.mGeoJsonFile));
            } else if (GeoJsonParser.isGeometry(type)) {
                GeoJsonFeature feature = GeoJsonParser.parseGeometryToFeature(this.mGeoJsonFile);
                if (feature != null) {
                    this.mGeoJsonFeatures.add(feature);
                }
            } else {
                Log.w((String)LOG_TAG, (String)"GeoJSON file could not be parsed.");
            }
        }
        catch (JSONException e) {
            Log.w((String)LOG_TAG, (String)"GeoJSON file could not be parsed.");
        }
    }

    private ArrayList<GeoJsonFeature> parseFeatureCollection(JSONObject geoJsonFeatureCollection) {
        JSONArray geoJsonFeatures;
        ArrayList<GeoJsonFeature> features = new ArrayList<GeoJsonFeature>();
        try {
            geoJsonFeatures = geoJsonFeatureCollection.getJSONArray(FEATURE_COLLECTION_ARRAY);
            if (geoJsonFeatureCollection.has(BOUNDING_BOX)) {
                this.mBoundingBox = GeoJsonParser.parseBoundingBox(geoJsonFeatureCollection.getJSONArray(BOUNDING_BOX));
            }
        }
        catch (JSONException e) {
            Log.w((String)LOG_TAG, (String)"Feature Collection could not be created.");
            return features;
        }
        for (int i = 0; i < geoJsonFeatures.length(); ++i) {
            try {
                JSONObject feature = geoJsonFeatures.getJSONObject(i);
                if (!feature.getString("type").equals(FEATURE)) continue;
                GeoJsonFeature parsedFeature = GeoJsonParser.parseFeature(feature);
                if (parsedFeature != null) {
                    features.add(parsedFeature);
                    continue;
                }
                Log.w((String)LOG_TAG, (String)("Index of Feature in Feature Collection that could not be created: " + i));
                continue;
            }
            catch (JSONException e) {
                Log.w((String)LOG_TAG, (String)("Index of Feature in Feature Collection that could not be created: " + i));
            }
        }
        return features;
    }

    ArrayList<GeoJsonFeature> getFeatures() {
        return this.mGeoJsonFeatures;
    }

    LatLngBounds getBoundingBox() {
        return this.mBoundingBox;
    }

    private static class LatLngAlt {
        public final LatLng latLng;
        public final Double altitude;

        LatLngAlt(LatLng latLng, Double altitude) {
            this.latLng = latLng;
            this.altitude = altitude;
        }
    }
}

