/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data.kml;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import androidx.annotation.RawRes;
import com.google.android.gms.maps.GoogleMap;
import com.google.maps.android.collections.GroundOverlayManager;
import com.google.maps.android.collections.MarkerManager;
import com.google.maps.android.collections.PolygonManager;
import com.google.maps.android.collections.PolylineManager;
import com.google.maps.android.data.Layer;
import com.google.maps.android.data.Renderer;
import com.google.maps.android.data.kml.KmlContainer;
import com.google.maps.android.data.kml.KmlGroundOverlay;
import com.google.maps.android.data.kml.KmlParser;
import com.google.maps.android.data.kml.KmlPlacemark;
import com.google.maps.android.data.kml.KmlRenderer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class KmlLayer
extends Layer {
    public KmlLayer(GoogleMap map, int resourceId, Context context) throws XmlPullParserException, IOException {
        this(map, context.getResources().openRawResource(resourceId), context, new MarkerManager(map), new PolygonManager(map), new PolylineManager(map), new GroundOverlayManager(map), null);
    }

    public KmlLayer(GoogleMap map, InputStream stream, Context context) throws XmlPullParserException, IOException {
        this(map, stream, context, new MarkerManager(map), new PolygonManager(map), new PolylineManager(map), new GroundOverlayManager(map), null);
    }

    public KmlLayer(GoogleMap map, @RawRes int resourceId, Context context, MarkerManager markerManager, PolygonManager polygonManager, PolylineManager polylineManager, GroundOverlayManager groundOverlayManager, Renderer.ImagesCache cache) throws XmlPullParserException, IOException {
        this(map, context.getResources().openRawResource(resourceId), context, markerManager, polygonManager, polylineManager, groundOverlayManager, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KmlLayer(GoogleMap map, InputStream stream, Context context, MarkerManager markerManager, PolygonManager polygonManager, PolylineManager polylineManager, GroundOverlayManager groundOverlayManager, Renderer.ImagesCache cache) throws XmlPullParserException, IOException {
        if (stream == null) {
            throw new IllegalArgumentException("KML InputStream cannot be null");
        }
        KmlRenderer renderer = new KmlRenderer(map, context, markerManager, polygonManager, polylineManager, groundOverlayManager, cache);
        BufferedInputStream bis = new BufferedInputStream(stream);
        bis.mark(1024);
        ZipInputStream zip = new ZipInputStream(bis);
        try {
            KmlParser parser = null;
            ZipEntry entry = zip.getNextEntry();
            if (entry != null) {
                HashMap<String, Bitmap> images = new HashMap<String, Bitmap>();
                while (entry != null) {
                    if (parser == null && entry.getName().toLowerCase().endsWith(".kml")) {
                        parser = KmlLayer.parseKml(zip);
                    } else {
                        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)zip);
                        if (bitmap != null) {
                            images.put(entry.getName(), bitmap);
                        } else {
                            Log.w((String)"KmlLayer", (String)("Unsupported KMZ contents file type: " + entry.getName()));
                        }
                    }
                    entry = zip.getNextEntry();
                }
                if (parser == null) {
                    throw new IllegalArgumentException("KML not found in InputStream");
                }
                renderer.storeKmzData(parser.getStyles(), parser.getStyleMaps(), parser.getPlacemarks(), parser.getContainers(), parser.getGroundOverlays(), images);
            } else {
                bis.reset();
                parser = KmlLayer.parseKml(bis);
                renderer.storeKmlData(parser.getStyles(), parser.getStyleMaps(), parser.getPlacemarks(), parser.getContainers(), parser.getGroundOverlays());
            }
            this.storeRenderer(renderer);
        }
        finally {
            stream.close();
            bis.close();
            zip.close();
        }
    }

    private static KmlParser parseKml(InputStream stream) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = KmlLayer.createXmlParser(stream);
        KmlParser parser = new KmlParser(xmlPullParser);
        parser.parseKml();
        return parser;
    }

    private static XmlPullParser createXmlParser(InputStream stream) throws XmlPullParserException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        parser.setInput(stream, null);
        return parser;
    }

    @Override
    public void addLayerToMap() {
        super.addKMLToMap();
    }

    public boolean hasPlacemarks() {
        return this.hasFeatures();
    }

    public Iterable<KmlPlacemark> getPlacemarks() {
        return this.getFeatures();
    }

    @Override
    public boolean hasContainers() {
        return super.hasContainers();
    }

    @Override
    public Iterable<KmlContainer> getContainers() {
        return super.getContainers();
    }

    @Override
    public Iterable<KmlGroundOverlay> getGroundOverlays() {
        return super.getGroundOverlays();
    }
}

