/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.tasks.vision.core;

import android.graphics.RectF;
import com.google.mediapipe.tasks.vision.core.ImageProcessingOptions;
import java.util.Optional;

final class AutoValue_ImageProcessingOptions
extends ImageProcessingOptions {
    private final Optional<RectF> regionOfInterest;
    private final int rotationDegrees;

    private AutoValue_ImageProcessingOptions(Optional<RectF> regionOfInterest, int rotationDegrees) {
        this.regionOfInterest = regionOfInterest;
        this.rotationDegrees = rotationDegrees;
    }

    @Override
    public Optional<RectF> regionOfInterest() {
        return this.regionOfInterest;
    }

    @Override
    public int rotationDegrees() {
        return this.rotationDegrees;
    }

    public String toString() {
        return "ImageProcessingOptions{regionOfInterest=" + this.regionOfInterest + ", rotationDegrees=" + this.rotationDegrees + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImageProcessingOptions) {
            ImageProcessingOptions that = (ImageProcessingOptions)o;
            return this.regionOfInterest.equals(that.regionOfInterest()) && this.rotationDegrees == that.rotationDegrees();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.regionOfInterest.hashCode();
        h$ *= 1000003;
        return h$ ^= this.rotationDegrees;
    }

    static final class Builder
    extends ImageProcessingOptions.Builder {
        private Optional<RectF> regionOfInterest = Optional.empty();
        private Integer rotationDegrees;

        Builder() {
        }

        @Override
        public ImageProcessingOptions.Builder setRegionOfInterest(RectF regionOfInterest) {
            this.regionOfInterest = Optional.of(regionOfInterest);
            return this;
        }

        @Override
        public ImageProcessingOptions.Builder setRotationDegrees(int rotationDegrees) {
            this.rotationDegrees = rotationDegrees;
            return this;
        }

        @Override
        ImageProcessingOptions autoBuild() {
            String missing = "";
            if (this.rotationDegrees == null) {
                missing = missing + " rotationDegrees";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ImageProcessingOptions(this.regionOfInterest, this.rotationDegrees);
        }
    }
}

